/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.synchronize;

import de.willuhn.datasource.BeanUtil;
import de.willuhn.jameica.hbci.HBCI;
import de.willuhn.jameica.hbci.HBCIProperties;
import de.willuhn.jameica.hbci.Settings;
import de.willuhn.jameica.hbci.SynchronizeOptions;
import de.willuhn.jameica.hbci.gui.DialogFactory;
import de.willuhn.jameica.hbci.rmi.Konto;
import de.willuhn.jameica.hbci.rmi.KontoType;
import de.willuhn.jameica.hbci.synchronize.SynchronizeBackend;
import de.willuhn.jameica.hbci.synchronize.SynchronizeJobProvider;
import de.willuhn.jameica.hbci.synchronize.SynchronizeSession;
import de.willuhn.jameica.hbci.synchronize.jobs.SynchronizeJob;
import de.willuhn.jameica.messaging.Message;
import de.willuhn.jameica.messaging.QueryMessage;
import de.willuhn.jameica.messaging.StatusBarMessage;
import de.willuhn.jameica.services.BeanService;
import de.willuhn.jameica.system.Application;
import de.willuhn.jameica.system.BackgroundTask;
import de.willuhn.jameica.system.OperationCanceledException;
import de.willuhn.logging.Level;
import de.willuhn.logging.Logger;
import de.willuhn.util.ApplicationException;
import de.willuhn.util.I18N;
import de.willuhn.util.ProgressMonitor;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public abstract class AbstractSynchronizeBackend<T extends SynchronizeJobProvider>
implements SynchronizeBackend {
    protected static final I18N i18n = Application.getPluginLoader().getPlugin(HBCI.class).getResources().getI18N();
    private List<T> providers = null;
    private SynchronizeSession session = null;
    protected Worker worker = null;

    public List<Konto> getSynchronizeKonten(Konto k) {
        List<Konto> list = k == null ? SynchronizeOptions.getSynchronizeKonten() : Arrays.asList(k);
        ArrayList<Konto> result = new ArrayList<Konto>();
        for (Konto konto : list) {
            try {
                if (konto.hasFlag(1)) continue;
                result.add(konto);
            }
            catch (RemoteException re) {
                Logger.error((String)"unable to determine flags of konto", (Throwable)re);
            }
        }
        return result;
    }

    protected abstract Class<T> getJobProviderInterface();

    protected abstract JobGroup createJobGroup(Konto var1);

    protected synchronized List<T> getJobProviders() {
        if (this.providers != null) {
            return this.providers;
        }
        this.providers = new ArrayList<T>();
        try {
            Class[] found;
            Logger.info((String)("loading synchronize providers for backend " + this.getName()));
            BeanService service = (BeanService)Application.getBootLoader().getBootable(BeanService.class);
            Class[] classArray = found = Application.getPluginLoader().getManifest(HBCI.class).getClassLoader().getClassFinder().findImplementors(this.getJobProviderInterface());
            int n = found.length;
            int n2 = 0;
            while (n2 < n) {
                Class c = classArray[n2];
                try {
                    Logger.debug((String)("  " + c.getSimpleName()));
                    this.providers.add((SynchronizeJobProvider)service.get(c));
                }
                catch (Exception e) {
                    Logger.error((String)("unable to load synchronize provider " + c.getName() + ", skipping"), (Throwable)e);
                }
                ++n2;
            }
            Logger.info((String)("  found " + this.providers.size() + " provider(s)"));
            Logger.debug((String)"provider order before sorting:");
            for (SynchronizeJobProvider p : this.providers) {
                Logger.debug((String)("  " + p.getClass().getSimpleName()));
            }
            Collections.sort(this.providers);
            Logger.debug((String)"provider order after sorting:");
            for (SynchronizeJobProvider p : this.providers) {
                Logger.debug((String)("  " + p.getClass().getSimpleName()));
            }
        }
        catch (ClassNotFoundException e) {
            Logger.warn((String)"no synchronize providers found");
        }
        catch (Exception e) {
            Logger.error((String)"error while searching vor synchronize providers", (Throwable)e);
        }
        return this.providers;
    }

    protected Class<? extends SynchronizeJob> getImplementor(Class<? extends SynchronizeJob> type, Konto konto) {
        KontoType kt = null;
        String id = null;
        try {
            kt = KontoType.find(konto != null ? konto.getAccountType() : null);
            id = konto != null ? konto.getID() : null;
        }
        catch (RemoteException re) {
            Logger.error((String)"unable to determine id/account-type for konto", (Throwable)re);
        }
        Logger.debug((String)("searching for implementation for synchronize job " + type.getSimpleName() + " for backend " + this.getName() + " [account-type " + (Object)((Object)kt) + ", konto ID: " + id + "]"));
        for (SynchronizeJobProvider p : this.getJobProviders()) {
            List<Class<? extends SynchronizeJob>> classes = p.getJobTypes();
            for (Class<? extends SynchronizeJob> c : classes) {
                if (!type.isAssignableFrom(c) || !p.supports(c, konto)) continue;
                Logger.debug((String)("    found " + c.getSimpleName()));
                return c;
            }
        }
        Logger.debug((String)"no implementation found");
        return null;
    }

    public <R> R create(Class<? extends SynchronizeJob> type, Konto konto) throws ApplicationException {
        try {
            if (konto == null || konto.hasFlag(1)) {
                throw new ApplicationException(i18n.tr("Das Konto ist deaktiviert"));
            }
        }
        catch (RemoteException re) {
            Logger.error((String)"unable to check konto flags", (Throwable)re);
            throw new ApplicationException(i18n.tr("Der Gesch\u00e4ftsvorfall konnte nicht erstellt werden: {0}", re.getMessage()));
        }
        Class<SynchronizeJob> job = this.getImplementor(type, konto);
        if (job == null) {
            throw new ApplicationException(i18n.tr("Der Gesch\u00e4ftsvorfall \"{0}\" wird f\u00fcr {1} nicht unterst\u00fctzt", new String[]{type.getSimpleName(), this.getName()}));
        }
        BeanService service = (BeanService)Application.getBootLoader().getBootable(BeanService.class);
        SynchronizeJob instance = (SynchronizeJob)service.get(job);
        instance.setKonto(konto);
        return (R)instance;
    }

    @Override
    public boolean supports(Class<? extends SynchronizeJob> type, Konto konto) {
        block3: {
            try {
                if (konto != null && !konto.hasFlag(1)) break block3;
                return false;
            }
            catch (RemoteException re) {
                Logger.error((String)("unable to determine support for job type " + type), (Throwable)re);
                return false;
            }
        }
        return this.getImplementor(type, konto) != null;
    }

    @Override
    public final List<SynchronizeJob> getSynchronizeJobs(Konto k) {
        LinkedList<SynchronizeJob> jobs = new LinkedList<SynchronizeJob>();
        for (Konto konto : this.getSynchronizeKonten(k)) {
            for (SynchronizeJobProvider provider : this.getJobProviders()) {
                try {
                    List<SynchronizeJob> list = provider.getSynchronizeJobs(konto);
                    if (list == null || list.size() == 0) continue;
                    jobs.addAll(list);
                }
                catch (Throwable t) {
                    Logger.error((String)("unable to determine synchronize jobs for provider " + provider.getClass().getName()), (Throwable)t);
                }
            }
        }
        return jobs;
    }

    @Override
    public List<String> getPropertyNames(Konto k) {
        return null;
    }

    @Override
    public synchronized SynchronizeSession execute(List<SynchronizeJob> jobs) throws ApplicationException, OperationCanceledException {
        SynchronizeSession s;
        if (this.session != null) {
            throw new ApplicationException(i18n.tr("Synchronisierung via {0} l\u00e4uft bereits", this.getName()));
        }
        Logger.info((String)("starting " + this.getName() + " synchronization"));
        this.worker = new Worker(jobs);
        this.session = s = new SynchronizeSession(this.worker);
        Application.getController().start((BackgroundTask)this.worker);
        return s;
    }

    @Override
    public final SynchronizeSession getCurrentSession() {
        return this.session;
    }

    protected abstract class JobGroup {
        private Konto konto = null;
        protected List<SynchronizeJob> jobs = new ArrayList<SynchronizeJob>();

        protected JobGroup(Konto k) {
            this.konto = k;
        }

        public Konto getKonto() {
            return this.konto;
        }

        private void add(SynchronizeJob job) {
            this.jobs.add(job);
        }

        protected abstract void sync() throws Exception;

        protected final void checkInterrupted() throws OperationCanceledException {
            if (AbstractSynchronizeBackend.this.worker.isInterrupted()) {
                throw new OperationCanceledException(i18n.tr("Synchronisierung durch Benutzer abgebrochen"));
            }
        }
    }

    protected class Synchronization {
        List<JobGroup> groups = new ArrayList<JobGroup>();

        protected Synchronization() {
        }

        private JobGroup get(Konto k) throws RemoteException {
            JobGroup group2;
            for (JobGroup group2 : this.groups) {
                if (!BeanUtil.equals((Object)group2.konto, (Object)k)) continue;
                return group2;
            }
            group2 = AbstractSynchronizeBackend.this.createJobGroup(k);
            this.groups.add(group2);
            return group2;
        }

        public final int size() {
            int i = 0;
            for (JobGroup group : this.groups) {
                i += group.jobs.size();
            }
            return i;
        }
    }

    protected class Worker
    implements BackgroundTask {
        private ProgressMonitor monitor = null;
        private JobGroup currentJobGroup = null;
        private Synchronization sync = null;
        private boolean interrupted = false;

        private Worker(List<SynchronizeJob> jobs) throws ApplicationException {
            if (jobs == null || jobs.size() == 0) {
                throw new ApplicationException(i18n.tr("Keine auszuf\u00fchrenden Auftr\u00e4ge ausgew\u00e4hlt"));
            }
            try {
                try {
                    this.sync = new Synchronization();
                    for (SynchronizeJob job : jobs) {
                        Konto konto = job.getKonto();
                        if (konto.hasFlag(1)) {
                            throw new ApplicationException(i18n.tr("Das Konto ist deaktiviert: {0}", konto.getLongName()));
                        }
                        JobGroup group = this.sync.get(job.getKonto());
                        group.add(job);
                    }
                    Logger.info((String)("accounts to synchronize: " + this.sync.groups.size() + ", jobs: " + this.sync.size()));
                }
                catch (RemoteException re) {
                    Logger.error((String)"error while performing synchronization", (Throwable)re);
                    throw new ApplicationException(i18n.tr("Synchronisierung fehlgeschlagen: {0}", re.getMessage()));
                }
            }
            finally {
                if (!Settings.getCachePin()) {
                    DialogFactory.clearPINCache(null);
                }
            }
        }

        public final ProgressMonitor getMonitor() {
            return this.monitor;
        }

        public final JobGroup getCurrentJobGroup() {
            return this.currentJobGroup;
        }

        public Synchronization getSynchronization() {
            return this.sync;
        }

        public final void run(ProgressMonitor monitor) throws ApplicationException {
            this.monitor = monitor;
            try {
                this.updateStatus(2, i18n.tr("Synchronisierung via {0} l\u00e4uft", AbstractSynchronizeBackend.this.getName()));
                int i = 0;
                while (i < this.sync.groups.size()) {
                    try {
                        if (!this.isInterrupted()) {
                            Logger.info((String)("BEGIN synchronization of account " + (i + 1) + "/" + this.sync.groups.size()));
                            this.currentJobGroup = this.sync.groups.get(i);
                            this.currentJobGroup.sync();
                            Logger.info((String)("END synchronization of account " + (i + 1) + "/" + this.sync.groups.size()));
                        }
                    }
                    catch (OperationCanceledException oce) {
                        Logger.warn((String)"operation cancelled");
                        Logger.write((Level)Level.DEBUG, (String)"stacktrace for debugging purpose", (Throwable)oce);
                        this.updateStatus(5, i18n.tr("Synchronisierung via {0} abgebrochen", AbstractSynchronizeBackend.this.getName()));
                        break;
                    }
                    catch (Exception e) {
                        if (e instanceof ApplicationException) {
                            Logger.write((Level)Level.INFO, (String)e.getMessage(), (Throwable)e);
                        } else {
                            Logger.error((String)"error while synchronizing", (Throwable)e);
                            Throwable t = HBCIProperties.getCause(e);
                            if (t instanceof Exception) {
                                e = (Exception)t;
                            }
                        }
                        boolean resume = false;
                        if (i + 1 < this.sync.groups.size()) {
                            QueryMessage msg = new QueryMessage((Object)e);
                            Application.getMessagingFactory().getMessagingQueue("hibiscus.sync.error").sendSyncMessage((Message)msg);
                            Object response = msg.getData();
                            boolean bl = resume = response instanceof Boolean && (Boolean)response != false;
                        }
                        if (!resume) {
                            if (e instanceof ApplicationException) {
                                this.updateStatus(3, e.getMessage());
                                break;
                            }
                            this.updateStatus(3, i18n.tr("Fehler: {0}", e.getMessage()));
                            break;
                        }
                        Logger.warn((String)"continue synchronization after error");
                        this.monitor.log(i18n.tr("Fehler: {0}", e.getMessage()));
                        this.monitor.log(i18n.tr("Synchronisierung via {0} wird nach Fehler fortgesetzt", AbstractSynchronizeBackend.this.getName()));
                    }
                    ++i;
                }
                if (AbstractSynchronizeBackend.this.session.getStatus() == 2) {
                    this.updateStatus(4, i18n.tr("Synchronisierung via {0} erfolgreich beendet", AbstractSynchronizeBackend.this.getName()));
                }
            }
            finally {
                this.log(AbstractSynchronizeBackend.this.session.getWarnings(), i18n.tr("Zusammengefasste Warnungen"));
                this.log(AbstractSynchronizeBackend.this.session.getErrors(), i18n.tr("Zusammengefasste Fehlermeldungen"));
                Logger.info((String)"stopping synchronization");
                AbstractSynchronizeBackend.this.worker = null;
                AbstractSynchronizeBackend.this.session = null;
                this.monitor.setPercentComplete(100);
                Logger.info((String)"finished");
            }
        }

        private void log(List<String> messages, String title) {
            if (messages == null || messages.size() == 0) {
                return;
            }
            this.monitor.log("");
            this.monitor.log("*****************************************************");
            this.monitor.log(String.valueOf(title) + ":");
            for (String m : messages) {
                this.monitor.log("   " + m);
            }
            this.monitor.log("*****************************************************");
        }

        private void updateStatus(int status, String text) {
            Logger.info((String)("updating synchronization status to: " + (String)ProgressMonitor.STATUS_MAP.get(status)));
            AbstractSynchronizeBackend.this.session.setStatus(status);
            this.monitor.setStatus(status);
            this.monitor.setStatusText(text);
            Application.getMessagingFactory().getMessagingQueue("hibiscus.sync.status").sendMessage((Message)new QueryMessage((Object)status));
            int type = status == 3 || status == 5 ? 1 : 0;
            Application.getMessagingFactory().sendMessage((Message)new StatusBarMessage(text, type));
        }

        public final void interrupt() {
            this.monitor.setStatusText(i18n.tr("Breche Synchronisierung via {0} ab", AbstractSynchronizeBackend.this.getName()));
            Logger.warn((String)"interrupting synchronization");
            this.interrupted = true;
            AbstractSynchronizeBackend.this.session.setStatus(5);
        }

        public final boolean isInterrupted() {
            return this.interrupted;
        }
    }
}

