/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.synchronize;

import de.willuhn.annotation.Lifecycle;
import de.willuhn.jameica.hbci.HBCI;
import de.willuhn.jameica.hbci.rmi.Konto;
import de.willuhn.jameica.hbci.synchronize.SynchronizeBackend;
import de.willuhn.jameica.hbci.synchronize.hbci.HBCISynchronizeBackend;
import de.willuhn.jameica.hbci.synchronize.jobs.SynchronizeJob;
import de.willuhn.jameica.services.BeanService;
import de.willuhn.jameica.system.Application;
import de.willuhn.logging.Logger;
import de.willuhn.util.ApplicationException;
import de.willuhn.util.I18N;
import java.rmi.RemoteException;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang.StringUtils;

@Lifecycle(value=Lifecycle.Type.CONTEXT)
public class SynchronizeEngine {
    public static final String STATUS = "hibiscus.syncengine.status";
    private static final I18N i18n = Application.getPluginLoader().getPlugin(HBCI.class).getResources().getI18N();
    private List<SynchronizeBackend> backends = null;
    private static final Class<? extends SynchronizeBackend> PRIMARY = HBCISynchronizeBackend.class;

    public synchronized List<SynchronizeBackend> getBackends() {
        if (this.backends != null) {
            return this.backends;
        }
        this.backends = new LinkedList<SynchronizeBackend>();
        try {
            Class[] found;
            Logger.info((String)"loading synchronize backends");
            BeanService service = (BeanService)Application.getBootLoader().getBootable(BeanService.class);
            Class[] classArray = found = Application.getPluginLoader().getPlugin(HBCI.class).getManifest().getClassLoader().getClassFinder().findImplementors(SynchronizeBackend.class);
            int n = found.length;
            int n2 = 0;
            while (n2 < n) {
                Class c = classArray[n2];
                try {
                    Logger.debug((String)("  " + c.getName()));
                    this.backends.add((SynchronizeBackend)service.get(c));
                }
                catch (Exception e) {
                    Logger.error((String)("unable to load synchronize backend " + c.getName() + ", skipping"), (Throwable)e);
                }
                ++n2;
            }
            Collections.sort(this.backends, new Comparator<SynchronizeBackend>(){

                @Override
                public int compare(SynchronizeBackend o1, SynchronizeBackend o2) {
                    if (PRIMARY.isInstance(o1)) {
                        return -1;
                    }
                    if (PRIMARY.isInstance(o2)) {
                        return 1;
                    }
                    return 0;
                }
            });
        }
        catch (ClassNotFoundException e) {
            Logger.warn((String)"no synchronize backends found");
        }
        catch (Exception e) {
            Logger.error((String)"error while searching vor synchronize backends", (Throwable)e);
        }
        return this.backends;
    }

    public SynchronizeBackend getBackend(Konto konto) {
        try {
            String s = konto != null ? StringUtils.trimToNull((String)konto.getBackendClass()) : null;
            for (SynchronizeBackend b : this.getBackends()) {
                if (s == null || !s.equals(b.getClass().getName())) continue;
                return b;
            }
        }
        catch (RemoteException re) {
            Logger.error((String)"unable to determine backend for konto", (Throwable)re);
        }
        return null;
    }

    public SynchronizeBackend getPrimary() {
        BeanService service = (BeanService)Application.getBootLoader().getBootable(BeanService.class);
        return (SynchronizeBackend)service.get(PRIMARY);
    }

    public SynchronizeBackend getBackend(Class<? extends SynchronizeJob> type, Konto konto) throws ApplicationException {
        SynchronizeBackend bk = this.getBackend(konto);
        if (bk != null) {
            return bk;
        }
        for (SynchronizeBackend backend : this.getBackends()) {
            if (!backend.supports(type, konto)) continue;
            return backend;
        }
        throw new ApplicationException(i18n.tr("Dieser Gesch\u00e4ftsvorfall wird f\u00fcr das angegebene Konto nicht unterst\u00fctzt"));
    }

    public boolean supports(Class<? extends SynchronizeJob> type, Konto konto) {
        try {
            this.getBackend(type, konto);
            return true;
        }
        catch (ApplicationException ae) {
            return false;
        }
    }
}

