/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.synchronize.hbci;

import de.willuhn.annotation.Lifecycle;
import de.willuhn.io.IOUtil;
import de.willuhn.jameica.gui.GUI;
import de.willuhn.jameica.hbci.HBCI;
import de.willuhn.jameica.hbci.HBCIProperties;
import de.willuhn.jameica.hbci.PassportRegistry;
import de.willuhn.jameica.hbci.gui.DialogFactory;
import de.willuhn.jameica.hbci.passport.Passport;
import de.willuhn.jameica.hbci.passport.PassportHandle;
import de.willuhn.jameica.hbci.rmi.Konto;
import de.willuhn.jameica.hbci.server.hbci.AbstractHBCIJob;
import de.willuhn.jameica.hbci.synchronize.AbstractSynchronizeBackend;
import de.willuhn.jameica.hbci.synchronize.SynchronizeBackend;
import de.willuhn.jameica.hbci.synchronize.SynchronizeEngine;
import de.willuhn.jameica.hbci.synchronize.SynchronizeSession;
import de.willuhn.jameica.hbci.synchronize.hbci.HBCISynchronizeJob;
import de.willuhn.jameica.hbci.synchronize.hbci.HBCISynchronizeJobProvider;
import de.willuhn.jameica.hbci.synchronize.hbci.HBCITraceMessage;
import de.willuhn.jameica.hbci.synchronize.jobs.SynchronizeJob;
import de.willuhn.jameica.messaging.Message;
import de.willuhn.jameica.system.Application;
import de.willuhn.jameica.system.OperationCanceledException;
import de.willuhn.logging.Level;
import de.willuhn.logging.Logger;
import de.willuhn.util.ApplicationException;
import de.willuhn.util.ProgressMonitor;
import java.io.Closeable;
import java.io.IOException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import javax.annotation.Resource;
import org.kapott.hbci.GV.HBCIJob;
import org.kapott.hbci.manager.HBCIHandler;

@Lifecycle(value=Lifecycle.Type.CONTEXT)
public class HBCISynchronizeBackend
extends AbstractSynchronizeBackend<HBCISynchronizeJobProvider> {
    public static final String HBCI_TRACE = "hibiscus.sync.hbci.trace";
    @Resource
    private SynchronizeEngine engine = null;

    @Override
    public String getName() {
        return "FinTS/HBCI";
    }

    @Override
    protected AbstractSynchronizeBackend.JobGroup createJobGroup(Konto k) {
        return new HBCIJobGroup(k);
    }

    @Override
    protected Class<HBCISynchronizeJobProvider> getJobProviderInterface() {
        return HBCISynchronizeJobProvider.class;
    }

    @Override
    public List<Konto> getSynchronizeKonten(Konto k) {
        List<Konto> list = super.getSynchronizeKonten(k);
        ArrayList<Konto> result = new ArrayList<Konto>();
        for (Konto konto : list) {
            if (!this.supports(konto)) continue;
            result.add(konto);
        }
        return result;
    }

    @Override
    public <T> T create(Class<? extends SynchronizeJob> type, Konto konto) throws ApplicationException {
        try {
            if (konto == null || konto.hasFlag(2) || konto.hasFlag(1)) {
                throw new ApplicationException(i18n.tr("Das Konto ist ein Offline-Konto oder deaktiviert"));
            }
        }
        catch (RemoteException re) {
            Logger.error((String)"unable to check konto flags", (Throwable)re);
            throw new ApplicationException(i18n.tr("Der Gesch\u00e4ftsvorfall konnte nicht erstellt werden: {0}", re.getMessage()));
        }
        return (T)super.create(type, konto);
    }

    @Override
    public boolean supports(Class<? extends SynchronizeJob> type, Konto konto) {
        if (!this.supports(konto)) {
            return false;
        }
        return super.supports(type, konto);
    }

    @Override
    public synchronized SynchronizeSession execute(List<SynchronizeJob> jobs) throws ApplicationException, OperationCanceledException {
        try {
            for (SynchronizeJob job : jobs) {
                Konto konto = job.getKonto();
                if (this.supports(konto)) continue;
                throw new ApplicationException(i18n.tr("Das Konto ist ein Offline-Konto oder das Zugangsverfahren {0} wurde nicht ausgew\u00e4hlt: {1}", new String[]{this.getName(), konto.getLongName()}));
            }
        }
        catch (RemoteException re) {
            Logger.error((String)"error while performing synchronization", (Throwable)re);
            throw new ApplicationException(i18n.tr("Synchronisierung fehlgeschlagen: {0}", re.getMessage()));
        }
        return super.execute(jobs);
    }

    @Override
    public List<String> getPropertyNames(Konto konto) {
        block5: {
            if (konto != null && !konto.hasFlag(1)) break block5;
            return null;
        }
        try {
            ArrayList<String> result = new ArrayList<String>();
            List providers = this.getJobProviders();
            for (HBCISynchronizeJobProvider p : providers) {
                List<String> props = p.getPropertyNames(konto);
                if (props == null || props.size() <= 0) continue;
                for (String s : props) {
                    if (result.contains(s)) continue;
                    result.add(s);
                }
            }
            return result;
        }
        catch (RemoteException re) {
            Logger.error((String)"unable to determine property-names", (Throwable)re);
            return null;
        }
    }

    private boolean supports(Konto konto) {
        block3: {
            try {
                if (konto != null && !konto.hasFlag(2) && !konto.hasFlag(1)) break block3;
                return false;
            }
            catch (RemoteException re) {
                Logger.error((String)"unable to determine synchronization support for konto", (Throwable)re);
                return false;
            }
        }
        SynchronizeBackend backend = this.engine.getBackend(konto);
        return backend == null || backend.equals(this);
    }

    protected class HBCIJobGroup
    extends AbstractSynchronizeBackend.JobGroup
    implements Closeable {
        private PassportHandle handle;
        private HBCIHandler handler;

        private HBCIJobGroup(Konto k) {
            super(k);
            this.handle = null;
            this.handler = null;
        }

        @Override
        protected void sync() throws Exception {
            ProgressMonitor monitor = HBCISynchronizeBackend.this.worker.getMonitor();
            Application.getMessagingFactory().getMessagingQueue(HBCISynchronizeBackend.HBCI_TRACE).sendMessage((Message)new HBCITraceMessage(HBCITraceMessage.Type.ID, this.getKonto().getID()));
            Application.getMessagingFactory().getMessagingQueue(HBCISynchronizeBackend.HBCI_TRACE).sendMessage((Message)new HBCITraceMessage(HBCITraceMessage.Type.INFO, "\n\n" + i18n.tr("{0} Synchronisiere Konto: {1}", new String[]{HBCI.LONGDATEFORMAT.format(new Date()), this.getKonto().getLongName()})));
            double chunk = 100.0 / (double)HBCISynchronizeBackend.this.worker.getSynchronization().size() * (double)this.jobs.size();
            double window = chunk - 6.0;
            HBCISynchronizeBackend.this.getCurrentSession().setProgressWindow(window);
            boolean ok = true;
            boolean inCatch = false;
            try {
                try {
                    this.checkInterrupted();
                    monitor.log(" ");
                    monitor.log(i18n.tr("Synchronisiere Konto: {0}", this.getKonto().getLongName()));
                    Passport passport = (Passport)new TaskPassportInit().execute();
                    this.handle = (PassportHandle)new TaskHandleInit(passport).execute();
                    this.handler = (HBCIHandler)new TaskHandleOpen(this.handle).execute();
                    Logger.info((String)"processing jobs");
                    ArrayList<AbstractHBCIJob> hbciJobs = new ArrayList<AbstractHBCIJob>();
                    for (SynchronizeJob job : this.jobs) {
                        this.checkInterrupted();
                        AbstractHBCIJob[] list = ((HBCISynchronizeJob)job).createHBCIJobs();
                        monitor.setStatusText(i18n.tr("F\u00fchre Gesch\u00e4ftsvorfall aus: \"{0}\"", job.getName()));
                        AbstractHBCIJob[] abstractHBCIJobArray = list;
                        int n = list.length;
                        int n2 = 0;
                        while (n2 < n) {
                            AbstractHBCIJob hbciJob = abstractHBCIJobArray[n2];
                            this.checkInterrupted();
                            hbciJobs.add(hbciJob);
                            ++n2;
                        }
                    }
                    ok = this.executeJobs(monitor, hbciJobs, ok);
                }
                catch (Exception e) {
                    ok = false;
                    inCatch = true;
                    throw e;
                }
            }
            catch (Throwable throwable) {
                try {
                    Application.getMessagingFactory().getMessagingQueue(HBCISynchronizeBackend.HBCI_TRACE).sendMessage((Message)new HBCITraceMessage(HBCITraceMessage.Type.CLOSE, this.getKonto().getID()));
                    monitor.addPercentComplete(3);
                    boolean interrupted = HBCISynchronizeBackend.this.worker.isInterrupted();
                    if (!ok || interrupted) {
                        Logger.warn((String)("found errors or synchronization cancelled, mark PIN cache dirty [have error: " + !ok + ", interrupted: " + interrupted + "]"));
                        DialogFactory.dirtyPINCache(this.handler != null ? this.handler.getPassport() : null);
                    }
                    if (!inCatch) {
                        if (!ok && !interrupted) {
                            throw new ApplicationException(i18n.tr("Es sind Fehler aufgetreten"));
                        }
                        this.checkInterrupted();
                    }
                }
                catch (Throwable throwable2) {
                    IOUtil.close((Closeable[])new Closeable[]{this});
                    throw throwable2;
                }
                IOUtil.close((Closeable[])new Closeable[]{this});
                throw throwable;
            }
            try {
                Application.getMessagingFactory().getMessagingQueue(HBCISynchronizeBackend.HBCI_TRACE).sendMessage((Message)new HBCITraceMessage(HBCITraceMessage.Type.CLOSE, this.getKonto().getID()));
                monitor.addPercentComplete(3);
                boolean interrupted = HBCISynchronizeBackend.this.worker.isInterrupted();
                if (!ok || interrupted) {
                    Logger.warn((String)("found errors or synchronization cancelled, mark PIN cache dirty [have error: " + !ok + ", interrupted: " + interrupted + "]"));
                    DialogFactory.dirtyPINCache(this.handler != null ? this.handler.getPassport() : null);
                }
                if (!inCatch) {
                    if (!ok && !interrupted) {
                        throw new ApplicationException(i18n.tr("Es sind Fehler aufgetreten"));
                    }
                    this.checkInterrupted();
                }
            }
            catch (Throwable throwable) {
                IOUtil.close((Closeable[])new Closeable[]{this});
                throw throwable;
            }
            IOUtil.close((Closeable[])new Closeable[]{this});
        }

        /*
         * Unable to fully structure code
         */
        private boolean executeJobs(ProgressMonitor monitor, List<AbstractHBCIJob> hbciJobs, boolean ok) throws Exception {
            try {
                monitor.setStatusText(HBCISynchronizeBackend.access$1().tr("F\u00fchre Auftr\u00e4ge aus..."));
                for (AbstractHBCIJob hbciJob : hbciJobs) {
                    this.checkInterrupted();
                    Logger.info((String)("adding job " + hbciJob.getIdentifier() + " to queue"));
                    j = this.handler.newJob(hbciJob.getIdentifier());
                    this.dumpJob(j);
                    hbciJob.setJob(j);
                    j.addToQueue();
                    if (!hbciJob.isExclusive()) continue;
                    Logger.info((String)"job will be executed in seperate hbci message");
                    this.handler.newMsg();
                }
                Logger.info((String)"executing jobs");
                this.handler.execute();
                monitor.setStatusText(HBCISynchronizeBackend.access$1().tr("Auftr\u00e4ge ausgef\u00fchrt"));
            }
            finally {
                followers = new ArrayList<AbstractHBCIJob>();
                ** for (hbciJob : hbciJobs)
            }
lbl-1000:
            // 1 sources

            {
                name = null;
                try {
                    name = hbciJob.getName();
                    Logger.info((String)("executing check for job " + hbciJob.getIdentifier()));
                    hbciJob.handleResult();
                    follower = hbciJob.getFollowerJobs();
                    if (follower == null || follower.size() <= 0) continue;
                    followers.addAll(follower);
                }
                catch (Throwable t) {
                    ok = false;
                    interrupted = HBCISynchronizeBackend.access$0(HBCISynchronizeBackend.this).isInterrupted();
                    Logger.write((Level)Level.DEBUG, (String)("error while processing job result, have error: " + (ok == false) + ", interrupted: " + interrupted), (Throwable)t);
                    if (interrupted) continue;
                    if (t instanceof ApplicationException) {
                        monitor.setStatusText(t.getMessage());
                        Logger.warn((String)t.getMessage());
                        Logger.write((Level)Level.DEBUG, (String)"stacktrace for debugging purpose", (Throwable)t);
                        continue;
                    }
                    monitor.setStatusText(HBCISynchronizeBackend.access$1().tr("Fehler beim Auswerten des HBCI-Auftrages {0}", name));
                    Logger.error((String)"error while processing job result", (Throwable)t);
                    monitor.log(t.getMessage());
                }
                continue;
            }
lbl46:
            // 1 sources

            if (followers != null && followers.size() > 0) {
                Logger.info((String)"executing follower jobs");
                this.executeJobs(monitor, followers, ok);
            }
            return ok;
        }

        private void dumpJob(HBCIJob job) {
            Logger.debug((String)("Job restrictions for " + job.getName()));
            Properties p = job.getJobRestrictions();
            for (String string : p.keySet()) {
                Logger.debug((String)("  " + string + ": " + p.getProperty(string)));
            }
        }

        @Override
        public void close() throws IOException {
            Logger.info((String)"closing resources");
            if (this.handle != null) {
                try {
                    this.handle.close();
                }
                catch (Throwable t) {
                    Logger.write((Level)Level.DEBUG, (String)"unable to close handle", (Throwable)t);
                }
            }
        }

        private abstract class AbstractTaskWrapper<T>
        implements Runnable {
            private Exception exception = null;
            private T result = null;

            private AbstractTaskWrapper() {
            }

            T execute() throws Exception {
                if (Application.inServerMode()) {
                    this.run();
                } else {
                    GUI.getDisplay().syncExec((Runnable)this);
                }
                if (this.exception != null) {
                    throw this.exception;
                }
                return this.result;
            }

            protected abstract T internalExecute() throws Throwable;

            @Override
            public void run() {
                try {
                    this.result = this.internalExecute();
                }
                catch (Exception e) {
                    this.exception = e;
                }
                catch (Throwable t) {
                    if (t instanceof Error) {
                        throw (Error)t;
                    }
                    throw new Error(t);
                }
            }
        }

        private class TaskHandleInit
        extends AbstractTaskWrapper<PassportHandle> {
            private Passport passport = null;

            private TaskHandleInit(Passport passport) {
                this.passport = passport;
            }

            @Override
            public PassportHandle internalExecute() throws Throwable {
                HBCIJobGroup.this.checkInterrupted();
                ProgressMonitor monitor = HBCISynchronizeBackend.this.worker.getMonitor();
                PassportHandle handle = this.passport.getHandle();
                if (handle == null) {
                    throw new ApplicationException(i18n.tr("Fehler beim Erzeugen der HBCI-Verbindung"));
                }
                monitor.addPercentComplete(1);
                return handle;
            }
        }

        private class TaskHandleOpen
        extends AbstractTaskWrapper<HBCIHandler> {
            private PassportHandle handle = null;

            private TaskHandleOpen(PassportHandle handle) {
                this.handle = handle;
            }

            @Override
            public HBCIHandler internalExecute() throws Throwable {
                HBCIJobGroup.this.checkInterrupted();
                ProgressMonitor monitor = HBCISynchronizeBackend.this.worker.getMonitor();
                try {
                    HBCIHandler handler = this.handle.open();
                    if (handler == null) {
                        throw new ApplicationException(i18n.tr("Fehler beim \u00d6ffnen der HBCI-Verbindung"));
                    }
                    monitor.addPercentComplete(1);
                    return handler;
                }
                catch (Exception e) {
                    throw HBCIProperties.getCause(e);
                }
            }
        }

        private class TaskPassportInit
        extends AbstractTaskWrapper<Passport> {
            private TaskPassportInit() {
            }

            @Override
            public Passport internalExecute() throws Throwable {
                HBCIJobGroup.this.checkInterrupted();
                ProgressMonitor monitor = HBCISynchronizeBackend.this.worker.getMonitor();
                Konto konto = HBCIJobGroup.this.getKonto();
                try {
                    Passport passport = PassportRegistry.findByClass(konto.getPassportClass());
                    if (passport == null) {
                        throw new ApplicationException(i18n.tr("Kein HBCI-Sicherheitsmedium f\u00fcr das Konto gefunden"));
                    }
                    monitor.setStatusText(i18n.tr("Initialisiere Bank-Zugang"));
                    passport.init(konto);
                    monitor.addPercentComplete(1);
                    return passport;
                }
                catch (Exception e) {
                    throw HBCIProperties.getCause(e);
                }
            }
        }
    }
}

