/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.synchronize.hbci;

import de.willuhn.jameica.hbci.HBCI;
import de.willuhn.jameica.hbci.SynchronizeOptions;
import de.willuhn.jameica.hbci.rmi.Konto;
import de.willuhn.jameica.hbci.server.BPDUtil;
import de.willuhn.jameica.hbci.server.KontoauszugPdfUtil;
import de.willuhn.jameica.hbci.server.hbci.AbstractHBCIJob;
import de.willuhn.jameica.hbci.server.hbci.HBCIKontoauszugJob;
import de.willuhn.jameica.hbci.synchronize.hbci.HBCISynchronizeJob;
import de.willuhn.jameica.hbci.synchronize.jobs.SynchronizeJobKontoauszugPdf;
import de.willuhn.jameica.system.Application;
import de.willuhn.logging.Logger;
import de.willuhn.util.ApplicationException;
import de.willuhn.util.I18N;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import org.kapott.hbci.GV_Result.GVRKontoauszug;

public class HBCISynchronizeJobKontoauszugPdf
extends SynchronizeJobKontoauszugPdf
implements HBCISynchronizeJob {
    private static final I18N i18n = Application.getPluginLoader().getPlugin(HBCI.class).getResources().getI18N();

    @Override
    public AbstractHBCIJob[] createHBCIJobs() throws RemoteException, ApplicationException {
        Konto k = (Konto)this.getContext("ctx.entity");
        Boolean force = (Boolean)this.getContext("ctx.konto.kontoauszugpdf.force");
        ArrayList<HBCIKontoauszugJob> jobs = new ArrayList<HBCIKontoauszugJob>();
        SynchronizeOptions o = new SynchronizeOptions(k);
        if (o.getSyncKontoauszuegePdf() || force != null && force.booleanValue()) {
            jobs.add(new HBCIKontoauszugJob(k));
        }
        return jobs.toArray(new AbstractHBCIJob[0]);
    }

    @Override
    public String getName() throws ApplicationException {
        try {
            Konto k = (Konto)this.getContext("ctx.entity");
            String format = null;
            BPDUtil.Support support = BPDUtil.getSupport(k, BPDUtil.Query.KontoauszugPdf);
            if (support != null && support.isSupported()) {
                format = "PDF";
            } else {
                support = BPDUtil.getSupport(k, BPDUtil.Query.Kontoauszug);
                if (support != null) {
                    List<GVRKontoauszug.Format> formats = KontoauszugPdfUtil.getFormats(support.getBpd());
                    if (formats.contains(GVRKontoauszug.Format.PDF)) {
                        format = "PDF";
                    } else if (formats.size() > 0) {
                        format = formats.get(0).name();
                    }
                }
            }
            if (format == null) {
                return i18n.tr("{0}: Elektronische Kontoausz\u00fcge abrufen", k.getLongName());
            }
            return i18n.tr("{0}: Elektr. Kontoausz\u00fcge im {1}-Format abrufen", new String[]{k.getLongName(), format});
        }
        catch (Exception e) {
            Logger.error((String)"unable to stringify job", (Throwable)e);
            return i18n.tr("Unbekannter Auftrag");
        }
    }
}

