/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.synchronize.hbci;

import de.willuhn.annotation.Lifecycle;
import de.willuhn.datasource.rmi.DBIterator;
import de.willuhn.jameica.hbci.SynchronizeOptions;
import de.willuhn.jameica.hbci.rmi.AuslandsUeberweisung;
import de.willuhn.jameica.hbci.rmi.Konto;
import de.willuhn.jameica.hbci.rmi.SepaSammelUeberweisung;
import de.willuhn.jameica.hbci.synchronize.hbci.AbstractHBCISynchronizeJobProvider;
import de.willuhn.jameica.hbci.synchronize.hbci.HBCISynchronizeBackend;
import de.willuhn.jameica.hbci.synchronize.hbci.HBCISynchronizeJobSepaSammelUeberweisung;
import de.willuhn.jameica.hbci.synchronize.hbci.HBCISynchronizeJobSepaUeberweisung;
import de.willuhn.jameica.hbci.synchronize.jobs.AbstractSynchronizeJob;
import de.willuhn.jameica.hbci.synchronize.jobs.SynchronizeJob;
import de.willuhn.jameica.hbci.synchronize.jobs.SynchronizeJobSepaSammelUeberweisung;
import de.willuhn.jameica.hbci.synchronize.jobs.SynchronizeJobSepaUeberweisung;
import de.willuhn.logging.Logger;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Resource;

@Lifecycle(value=Lifecycle.Type.CONTEXT)
public class HBCISynchronizeJobProviderAuslandsUeberweisung
extends AbstractHBCISynchronizeJobProvider {
    @Resource
    private HBCISynchronizeBackend backend = null;
    private static final List<Class<? extends SynchronizeJob>> JOBS = new ArrayList<Class<? extends SynchronizeJob>>(){
        {
            this.add(HBCISynchronizeJobSepaUeberweisung.class);
            this.add(HBCISynchronizeJobSepaSammelUeberweisung.class);
        }
    };

    @Override
    public List<SynchronizeJob> getSynchronizeJobs(Konto k) {
        LinkedList<SynchronizeJob> jobs = new LinkedList<SynchronizeJob>();
        for (Konto kt : this.backend.getSynchronizeKonten(k)) {
            try {
                AbstractSynchronizeJob job;
                SynchronizeOptions options = new SynchronizeOptions(kt);
                if (!options.getSyncAuslandsUeberweisungen()) continue;
                DBIterator list = kt.getAuslandsUeberweisungen();
                list.addFilter("(ausgefuehrt is null or ausgefuehrt = 0)");
                while (list.hasNext()) {
                    AuslandsUeberweisung u = (AuslandsUeberweisung)list.next();
                    if (!u.ueberfaellig() || u.ausgefuehrt()) continue;
                    job = (SynchronizeJobSepaUeberweisung)this.backend.create(SynchronizeJobSepaUeberweisung.class, kt);
                    job.setContext("ctx.entity", u);
                    jobs.add(job);
                }
                list = k.getSepaSammelUeberweisungen();
                list.addFilter("(ausgefuehrt is null or ausgefuehrt = 0)");
                while (list.hasNext()) {
                    SepaSammelUeberweisung su = (SepaSammelUeberweisung)list.next();
                    if (!su.ueberfaellig() || su.ausgefuehrt()) continue;
                    job = (SynchronizeJobSepaSammelUeberweisung)this.backend.create(SynchronizeJobSepaSammelUeberweisung.class, kt);
                    job.setContext("ctx.entity", su);
                    jobs.add(job);
                }
            }
            catch (Exception e) {
                Logger.error((String)"unable to load synchronize jobs", (Throwable)e);
            }
        }
        return jobs;
    }

    @Override
    public boolean supports(Class<? extends SynchronizeJob> type, Konto k) {
        return true;
    }

    @Override
    public List<Class<? extends SynchronizeJob>> getJobTypes() {
        return JOBS;
    }

    public int compareTo(Object o) {
        return -1;
    }
}

