/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.synchronize.hbci;

import de.willuhn.annotation.Lifecycle;
import de.willuhn.jameica.hbci.SynchronizeOptions;
import de.willuhn.jameica.hbci.rmi.Konto;
import de.willuhn.jameica.hbci.rmi.KontoType;
import de.willuhn.jameica.hbci.synchronize.hbci.AbstractHBCISynchronizeJobProvider;
import de.willuhn.jameica.hbci.synchronize.hbci.HBCISynchronizeBackend;
import de.willuhn.jameica.hbci.synchronize.hbci.HBCISynchronizeJobKontoauszug;
import de.willuhn.jameica.hbci.synchronize.jobs.SynchronizeJob;
import de.willuhn.jameica.hbci.synchronize.jobs.SynchronizeJobKontoauszug;
import de.willuhn.logging.Logger;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.annotation.Resource;

@Lifecycle(value=Lifecycle.Type.CONTEXT)
public class HBCISynchronizeJobProviderKontoauszug
extends AbstractHBCISynchronizeJobProvider {
    @Resource
    private HBCISynchronizeBackend backend = null;
    private static final List<Class<? extends SynchronizeJob>> JOBS = new ArrayList<Class<? extends SynchronizeJob>>(){
        {
            this.add(HBCISynchronizeJobKontoauszug.class);
        }
    };
    private static final Set<KontoType> UNSUPPORTED = new HashSet<KontoType>(){
        {
            this.add(KontoType.FONDSDEPOT);
            this.add(KontoType.WERTPAPIERDEPOT);
        }
    };

    @Override
    public List<SynchronizeJob> getSynchronizeJobs(Konto k) {
        LinkedList<SynchronizeJob> jobs = new LinkedList<SynchronizeJob>();
        for (Konto kt : this.backend.getSynchronizeKonten(k)) {
            try {
                SynchronizeOptions options;
                KontoType type = KontoType.find(kt.getAccountType());
                if (type != null && UNSUPPORTED.contains((Object)type) || !(options = new SynchronizeOptions(kt)).getSyncKontoauszuege() && !options.getSyncSaldo()) continue;
                SynchronizeJobKontoauszug job = (SynchronizeJobKontoauszug)this.backend.create(SynchronizeJobKontoauszug.class, kt);
                job.setContext("ctx.entity", kt);
                jobs.add(job);
            }
            catch (Exception e) {
                Logger.error((String)"unable to load synchronize jobs", (Throwable)e);
            }
        }
        return jobs;
    }

    @Override
    public boolean supports(Class<? extends SynchronizeJob> type, Konto k) {
        KontoType kt;
        block4: {
            if (k == null) {
                return true;
            }
            kt = null;
            try {
                kt = KontoType.find(k.getAccountType());
                if (kt != null) break block4;
                return true;
            }
            catch (RemoteException re) {
                Logger.error((String)("unable to determine support for account-type " + (Object)((Object)kt)), (Throwable)re);
                return false;
            }
        }
        return !UNSUPPORTED.contains((Object)kt);
    }

    @Override
    public List<Class<? extends SynchronizeJob>> getJobTypes() {
        return JOBS;
    }

    public int compareTo(Object o) {
        return 1;
    }
}

