/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.synchronize.hbci;

import de.willuhn.annotation.Lifecycle;
import de.willuhn.jameica.hbci.SynchronizeOptions;
import de.willuhn.jameica.hbci.rmi.Konto;
import de.willuhn.jameica.hbci.rmi.KontoauszugInterval;
import de.willuhn.jameica.hbci.server.KontoauszugPdfUtil;
import de.willuhn.jameica.hbci.synchronize.hbci.AbstractHBCISynchronizeJobProvider;
import de.willuhn.jameica.hbci.synchronize.hbci.HBCISynchronizeBackend;
import de.willuhn.jameica.hbci.synchronize.hbci.HBCISynchronizeJobKontoauszugPdf;
import de.willuhn.jameica.hbci.synchronize.jobs.SynchronizeJob;
import de.willuhn.jameica.hbci.synchronize.jobs.SynchronizeJobKontoauszugPdf;
import de.willuhn.logging.Logger;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Resource;

@Lifecycle(value=Lifecycle.Type.CONTEXT)
public class HBCISynchronizeJobProviderKontoauszugPdf
extends AbstractHBCISynchronizeJobProvider {
    @Resource
    private HBCISynchronizeBackend backend = null;
    private static final List<Class<? extends SynchronizeJob>> JOBS = new ArrayList<Class<? extends SynchronizeJob>>(){
        {
            this.add(HBCISynchronizeJobKontoauszugPdf.class);
        }
    };

    @Override
    public List<SynchronizeJob> getSynchronizeJobs(Konto k) {
        LinkedList<SynchronizeJob> jobs = new LinkedList<SynchronizeJob>();
        for (Konto kt : this.backend.getSynchronizeKonten(k)) {
            try {
                Date next;
                SynchronizeOptions options = new SynchronizeOptions(kt);
                if (!options.getSyncKontoauszuegePdf() || !KontoauszugPdfUtil.supported(kt) || (next = KontoauszugInterval.getNextInterval(k)) == null || next.after(new Date())) continue;
                SynchronizeJobKontoauszugPdf job = (SynchronizeJobKontoauszugPdf)this.backend.create(SynchronizeJobKontoauszugPdf.class, kt);
                job.setContext("ctx.entity", kt);
                jobs.add(job);
            }
            catch (Exception e) {
                Logger.error((String)"unable to load synchronize jobs", (Throwable)e);
            }
        }
        return jobs;
    }

    @Override
    public boolean supports(Class<? extends SynchronizeJob> type, Konto k) {
        if (k == null) {
            return true;
        }
        return KontoauszugPdfUtil.supported(k);
    }

    @Override
    public List<Class<? extends SynchronizeJob>> getJobTypes() {
        return JOBS;
    }

    public int compareTo(Object o) {
        return 10;
    }
}

