/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.synchronize.hbci;

import de.willuhn.annotation.Lifecycle;
import de.willuhn.datasource.rmi.DBIterator;
import de.willuhn.jameica.hbci.SynchronizeOptions;
import de.willuhn.jameica.hbci.rmi.Konto;
import de.willuhn.jameica.hbci.rmi.SepaDauerauftrag;
import de.willuhn.jameica.hbci.synchronize.hbci.AbstractHBCISynchronizeJobProvider;
import de.willuhn.jameica.hbci.synchronize.hbci.HBCISynchronizeBackend;
import de.willuhn.jameica.hbci.synchronize.hbci.HBCISynchronizeJobSepaDauerauftragDelete;
import de.willuhn.jameica.hbci.synchronize.hbci.HBCISynchronizeJobSepaDauerauftragList;
import de.willuhn.jameica.hbci.synchronize.hbci.HBCISynchronizeJobSepaDauerauftragStore;
import de.willuhn.jameica.hbci.synchronize.jobs.SynchronizeJob;
import de.willuhn.jameica.hbci.synchronize.jobs.SynchronizeJobSepaDauerauftragList;
import de.willuhn.jameica.hbci.synchronize.jobs.SynchronizeJobSepaDauerauftragStore;
import de.willuhn.logging.Logger;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Resource;

@Lifecycle(value=Lifecycle.Type.CONTEXT)
public class HBCISynchronizeJobProviderSepaDauerauftrag
extends AbstractHBCISynchronizeJobProvider {
    @Resource
    private HBCISynchronizeBackend backend = null;
    private static final List<Class<? extends SynchronizeJob>> JOBS = new ArrayList<Class<? extends SynchronizeJob>>(){
        {
            this.add(HBCISynchronizeJobSepaDauerauftragDelete.class);
            this.add(HBCISynchronizeJobSepaDauerauftragStore.class);
            this.add(HBCISynchronizeJobSepaDauerauftragList.class);
        }
    };

    @Override
    public List<SynchronizeJob> getSynchronizeJobs(Konto k) {
        LinkedList<SynchronizeJob> jobs = new LinkedList<SynchronizeJob>();
        for (Konto kt : this.backend.getSynchronizeKonten(k)) {
            try {
                SynchronizeOptions options = new SynchronizeOptions(kt);
                if (!options.getSyncSepaDauerauftraege()) continue;
                DBIterator list = kt.getSepaDauerauftraege();
                while (list.hasNext()) {
                    SepaDauerauftrag d = (SepaDauerauftrag)list.next();
                    if (d.isActive()) continue;
                    SynchronizeJobSepaDauerauftragStore job = (SynchronizeJobSepaDauerauftragStore)this.backend.create(SynchronizeJobSepaDauerauftragStore.class, kt);
                    job.setContext("ctx.entity", d);
                    jobs.add(job);
                }
                SynchronizeJobSepaDauerauftragList job = (SynchronizeJobSepaDauerauftragList)this.backend.create(SynchronizeJobSepaDauerauftragList.class, kt);
                job.setContext("ctx.entity", kt);
                jobs.add(job);
            }
            catch (Exception e) {
                Logger.error((String)"unable to load synchronize jobs", (Throwable)e);
            }
        }
        return jobs;
    }

    @Override
    public boolean supports(Class<? extends SynchronizeJob> type, Konto k) {
        return true;
    }

    @Override
    public List<Class<? extends SynchronizeJob>> getJobTypes() {
        return JOBS;
    }

    public int compareTo(Object o) {
        return -1;
    }
}

