/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.synchronize.hbci;

import de.willuhn.annotation.Lifecycle;
import de.willuhn.datasource.rmi.DBIterator;
import de.willuhn.jameica.hbci.SynchronizeOptions;
import de.willuhn.jameica.hbci.rmi.Konto;
import de.willuhn.jameica.hbci.rmi.SepaLastschrift;
import de.willuhn.jameica.hbci.rmi.SepaSammelLastschrift;
import de.willuhn.jameica.hbci.synchronize.hbci.AbstractHBCISynchronizeJobProvider;
import de.willuhn.jameica.hbci.synchronize.hbci.HBCISynchronizeBackend;
import de.willuhn.jameica.hbci.synchronize.hbci.HBCISynchronizeJobSepaLastschrift;
import de.willuhn.jameica.hbci.synchronize.hbci.HBCISynchronizeJobSepaSammelLastschrift;
import de.willuhn.jameica.hbci.synchronize.jobs.AbstractSynchronizeJob;
import de.willuhn.jameica.hbci.synchronize.jobs.SynchronizeJob;
import de.willuhn.jameica.hbci.synchronize.jobs.SynchronizeJobSepaLastschrift;
import de.willuhn.jameica.hbci.synchronize.jobs.SynchronizeJobSepaSammelLastschrift;
import de.willuhn.logging.Logger;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Resource;

@Lifecycle(value=Lifecycle.Type.CONTEXT)
public class HBCISynchronizeJobProviderSepaLastschrift
extends AbstractHBCISynchronizeJobProvider {
    @Resource
    private HBCISynchronizeBackend backend = null;
    private static final List<Class<? extends SynchronizeJob>> JOBS = new ArrayList<Class<? extends SynchronizeJob>>(){
        {
            this.add(HBCISynchronizeJobSepaLastschrift.class);
            this.add(HBCISynchronizeJobSepaSammelLastschrift.class);
        }
    };

    @Override
    public List<SynchronizeJob> getSynchronizeJobs(Konto k) {
        LinkedList<SynchronizeJob> jobs = new LinkedList<SynchronizeJob>();
        for (Konto kt : this.backend.getSynchronizeKonten(k)) {
            try {
                AbstractSynchronizeJob job;
                SynchronizeOptions options = new SynchronizeOptions(kt);
                if (!options.getSyncSepaLastschriften()) continue;
                DBIterator list = kt.getSepaLastschriften();
                list.addFilter("(ausgefuehrt is null or ausgefuehrt = 0)");
                while (list.hasNext()) {
                    SepaLastschrift u = (SepaLastschrift)list.next();
                    if (!u.ueberfaellig() || u.ausgefuehrt()) continue;
                    job = (SynchronizeJobSepaLastschrift)this.backend.create(SynchronizeJobSepaLastschrift.class, kt);
                    job.setContext("ctx.entity", u);
                    jobs.add(job);
                }
                list = k.getSepaSammelLastschriften();
                list.addFilter("(ausgefuehrt is null or ausgefuehrt = 0)");
                while (list.hasNext()) {
                    SepaSammelLastschrift sl = (SepaSammelLastschrift)list.next();
                    if (!sl.ueberfaellig() || sl.ausgefuehrt()) continue;
                    job = (SynchronizeJobSepaSammelLastschrift)this.backend.create(SynchronizeJobSepaSammelLastschrift.class, kt);
                    job.setContext("ctx.entity", sl);
                    jobs.add(job);
                }
            }
            catch (Exception e) {
                Logger.error((String)"unable to load synchronize jobs", (Throwable)e);
            }
        }
        return jobs;
    }

    @Override
    public boolean supports(Class<? extends SynchronizeJob> type, Konto k) {
        return true;
    }

    @Override
    public List<Class<? extends SynchronizeJob>> getJobTypes() {
        return JOBS;
    }

    public int compareTo(Object o) {
        return -1;
    }
}

