/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.synchronize.hbci;

import de.willuhn.jameica.hbci.HBCI;
import de.willuhn.jameica.hbci.rmi.Konto;
import de.willuhn.jameica.hbci.rmi.Kontoauszug;
import de.willuhn.jameica.hbci.server.hbci.AbstractHBCIJob;
import de.willuhn.jameica.hbci.server.hbci.HBCIQuittungJob;
import de.willuhn.jameica.hbci.synchronize.hbci.HBCISynchronizeJob;
import de.willuhn.jameica.hbci.synchronize.jobs.SynchronizeJobQuittung;
import de.willuhn.jameica.system.Application;
import de.willuhn.logging.Logger;
import de.willuhn.util.ApplicationException;
import de.willuhn.util.I18N;
import java.rmi.RemoteException;

public class HBCISynchronizeJobQuittung
extends SynchronizeJobQuittung
implements HBCISynchronizeJob {
    private static final I18N i18n = Application.getPluginLoader().getPlugin(HBCI.class).getResources().getI18N();

    @Override
    public AbstractHBCIJob[] createHBCIJobs() throws RemoteException, ApplicationException {
        Kontoauszug ka = (Kontoauszug)this.getContext("ctx.entity");
        return new AbstractHBCIJob[]{new HBCIQuittungJob(ka)};
    }

    @Override
    public String getName() throws ApplicationException {
        try {
            Kontoauszug ka = (Kontoauszug)this.getContext("ctx.entity");
            Konto k = ka.getKonto();
            Integer jahr = ka.getJahr();
            Integer nr = ka.getNummer();
            if (jahr != null && nr != null) {
                return i18n.tr("{0}: Empfang von Kontoauszug {1}-{2} quittieren", new String[]{k.getLongName(), Integer.toString(jahr), Integer.toString(nr)});
            }
            return i18n.tr("{0}: Empfang von Kontoauszug quittieren", k.getLongName());
        }
        catch (Exception e) {
            Logger.error((String)"unable to stringify job", (Throwable)e);
            return i18n.tr("Unbekannter Auftrag");
        }
    }
}

