/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.synchronize.hbci;

import de.willuhn.annotation.Lifecycle;
import de.willuhn.jameica.hbci.synchronize.hbci.HBCITraceMessage;
import de.willuhn.jameica.messaging.Message;
import de.willuhn.jameica.messaging.MessageConsumer;
import de.willuhn.logging.Logger;
import de.willuhn.util.History;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Lifecycle(value=Lifecycle.Type.CONTEXT)
public class HBCITraceMessageConsumer
implements MessageConsumer {
    private Map<String, History> history = new HashMap<String, History>();
    private History current = null;

    public Class[] getExpectedMessageTypes() {
        return new Class[]{HBCITraceMessage.class};
    }

    public void handleMessage(Message message) throws Exception {
        HBCITraceMessage msg = (HBCITraceMessage)message;
        if (msg.getType() != HBCITraceMessage.Type.ID && this.current == null) {
            History anon = this.history.get(null);
            if (anon == null) {
                anon = new History(100);
                this.history.put(null, anon);
            }
            anon.push((Object)msg);
            return;
        }
        if (msg.getType() == HBCITraceMessage.Type.CLOSE) {
            this.current = null;
            return;
        }
        if (msg.getType() == HBCITraceMessage.Type.ID) {
            this.current = this.history.get(msg.getData());
            if (this.current == null) {
                this.current = new History(100);
                this.history.put(msg.getData(), this.current);
            }
            return;
        }
        if (this.current == null) {
            Logger.debug((String)"no ID to assign HBCI trace to");
            return;
        }
        this.current.push((Object)msg);
    }

    public List<HBCITraceMessage> getTrace(String id) {
        History h = this.history.get(id);
        ArrayList<HBCITraceMessage> list = new ArrayList<HBCITraceMessage>();
        if (h != null) {
            list.addAll(h.elements());
        }
        return list;
    }

    public boolean autoRegister() {
        return false;
    }
}

