/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.synchronize.scripting;

import de.willuhn.annotation.Lifecycle;
import de.willuhn.jameica.hbci.rmi.Konto;
import de.willuhn.jameica.hbci.synchronize.AbstractSynchronizeBackend;
import de.willuhn.jameica.hbci.synchronize.SynchronizeBackend;
import de.willuhn.jameica.hbci.synchronize.SynchronizeEngine;
import de.willuhn.jameica.hbci.synchronize.SynchronizeSession;
import de.willuhn.jameica.hbci.synchronize.jobs.SynchronizeJob;
import de.willuhn.jameica.hbci.synchronize.scripting.ScriptingSynchronizeJobProvider;
import de.willuhn.jameica.messaging.Message;
import de.willuhn.jameica.messaging.QueryMessage;
import de.willuhn.jameica.system.Application;
import de.willuhn.jameica.system.OperationCanceledException;
import de.willuhn.logging.Logger;
import de.willuhn.util.ApplicationException;
import de.willuhn.util.ProgressMonitor;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;

@Lifecycle(value=Lifecycle.Type.CONTEXT)
public class ScriptingSynchronizeBackend
extends AbstractSynchronizeBackend<ScriptingSynchronizeJobProvider> {
    private static final String CTX_JS_FUNCTION = "ctx.js.function";
    @Resource
    private SynchronizeEngine engine = null;

    @Override
    public String getName() {
        return "Scripting";
    }

    @Override
    protected Class<ScriptingSynchronizeJobProvider> getJobProviderInterface() {
        return ScriptingSynchronizeJobProvider.class;
    }

    @Override
    protected AbstractSynchronizeBackend.JobGroup createJobGroup(Konto k) {
        return new ScriptingJobGroup(k);
    }

    @Override
    public List<Konto> getSynchronizeKonten(Konto k) {
        List<Konto> list = super.getSynchronizeKonten(k);
        ArrayList<Konto> result = new ArrayList<Konto>();
        for (Konto konto : list) {
            if (!this.supports(konto)) continue;
            result.add(konto);
        }
        return result;
    }

    @Override
    public <T> T create(Class<? extends SynchronizeJob> type, Konto konto) throws ApplicationException {
        String function = this.getFunction(type, konto);
        if (function == null) {
            Logger.warn((String)("job type " + type.getSimpleName() + " not supported by " + this.getName()));
            throw new ApplicationException(i18n.tr("Der Gesch\u00e4ftsvorfall wird nicht via {0} unterst\u00fctzt", this.getName()));
        }
        SynchronizeJob instance = (SynchronizeJob)super.create(type, konto);
        instance.setContext(CTX_JS_FUNCTION, function);
        return (T)instance;
    }

    @Override
    public boolean supports(Class<? extends SynchronizeJob> type, Konto konto) {
        if (this.getFunction(type, konto) == null) {
            return false;
        }
        return super.supports(type, konto);
    }

    @Override
    public synchronized SynchronizeSession execute(List<SynchronizeJob> jobs) throws ApplicationException, OperationCanceledException {
        try {
            for (SynchronizeJob job : jobs) {
                Konto konto = job.getKonto();
                if (this.supports(konto)) continue;
                throw new ApplicationException(i18n.tr("Das Konto ist kein Offline-Konto oder das Zugangsverfahren {0} wurde nicht ausgew\u00e4hlt: {1}", new String[]{this.getName(), konto.getLongName()}));
            }
        }
        catch (RemoteException re) {
            Logger.error((String)"error while performing synchronization", (Throwable)re);
            throw new ApplicationException(i18n.tr("Synchronisierung fehlgeschlagen: {0}", re.getMessage()));
        }
        return super.execute(jobs);
    }

    boolean supports(Konto konto) {
        if (konto == null) {
            return false;
        }
        try {
            SynchronizeBackend backend = this.engine.getBackend(konto);
            return konto.hasFlag(2) || backend != null && backend.equals(this);
        }
        catch (RemoteException re) {
            Logger.error((String)"unable to determine synchronization support for konto", (Throwable)re);
            return false;
        }
    }

    @Override
    public List<String> getPropertyNames(Konto konto) {
        Object data;
        block6: {
            block5: {
                if (konto != null && this.supports(konto) && !konto.hasFlag(1)) break block5;
                return null;
            }
            QueryMessage msg = new QueryMessage("hibiscus.sync.options", (Object)konto);
            Application.getMessagingFactory().getMessagingQueue("jameica.scripting").sendSyncMessage((Message)msg);
            data = msg.getData();
            if (data != null) break block6;
            Logger.debug((String)"no property names found");
            return null;
        }
        try {
            ArrayList<String> result = new ArrayList<String>();
            List<Object> list = data instanceof List ? (List<Object>)data : Arrays.asList(data);
            for (Object e : list) {
                if (e instanceof Exception || !(e instanceof String)) continue;
                result.add((String)e);
            }
            return result;
        }
        catch (RemoteException re) {
            Logger.error((String)"unable to determine property-names", (Throwable)re);
            return null;
        }
    }

    private String getFunction(Class<? extends SynchronizeJob> type, Konto konto) {
        block5: {
            if (konto != null && this.supports(konto) && !konto.hasFlag(1)) break block5;
            return null;
        }
        try {
            Logger.debug((String)("searching javascript function for job type " + type.getSimpleName()));
            QueryMessage msg = new QueryMessage("hibiscus.sync.function", (Object)new Object[]{konto, type});
            Application.getMessagingFactory().getMessagingQueue("jameica.scripting").sendSyncMessage((Message)msg);
            Object data = msg.getData();
            if (data != null) {
                List<Object> result = data instanceof List ? (List<Object>)data : Arrays.asList(data);
                for (Object e : result) {
                    if (e instanceof Exception || !(e instanceof String)) continue;
                    Logger.debug((String)("found " + e));
                    return (String)e;
                }
            }
            Logger.debug((String)"no javascript function found");
            return null;
        }
        catch (RemoteException re) {
            Logger.error((String)("unable to determine support for job type " + type), (Throwable)re);
            return null;
        }
    }

    protected class ScriptingJobGroup
    extends AbstractSynchronizeBackend.JobGroup {
        protected ScriptingJobGroup(Konto k) {
            super(k);
        }

        @Override
        protected void sync() throws Exception {
            ProgressMonitor monitor = ScriptingSynchronizeBackend.this.worker.getMonitor();
            String kn = this.getKonto().getLongName();
            int step = 100 / ScriptingSynchronizeBackend.this.worker.getSynchronization().size();
            this.checkInterrupted();
            monitor.log(" ");
            monitor.log(i18n.tr("Synchronisiere Konto: {0}", kn));
            Logger.info((String)"processing jobs");
            for (SynchronizeJob job : this.jobs) {
                this.checkInterrupted();
                String function = (String)job.getContext(ScriptingSynchronizeBackend.CTX_JS_FUNCTION);
                if (StringUtils.isEmpty((String)function)) {
                    throw new ApplicationException(i18n.tr("Kein g\u00fcltiger Scripting-Auftrag: {0}", job.getName()));
                }
                Logger.info((String)("executing javascript function " + function));
                QueryMessage msg = new QueryMessage("function." + function, (Object)new Object[]{job, ScriptingSynchronizeBackend.this.getCurrentSession()});
                Application.getMessagingFactory().getMessagingQueue("jameica.scripting").sendSyncMessage((Message)msg);
                monitor.addPercentComplete(step);
                Object data = msg.getData();
                List<Object> list = data instanceof List ? (List<Object>)data : Arrays.asList(data);
                for (Object e : list) {
                    if (!(e instanceof Exception)) continue;
                    throw (Exception)e;
                }
            }
        }
    }
}

