/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.synchronize.scripting;

import de.willuhn.annotation.Lifecycle;
import de.willuhn.jameica.hbci.SynchronizeOptions;
import de.willuhn.jameica.hbci.rmi.Konto;
import de.willuhn.jameica.hbci.synchronize.jobs.SynchronizeJob;
import de.willuhn.jameica.hbci.synchronize.jobs.SynchronizeJobKontoauszug;
import de.willuhn.jameica.hbci.synchronize.scripting.ScriptingSynchronizeBackend;
import de.willuhn.jameica.hbci.synchronize.scripting.ScriptingSynchronizeJobProvider;
import de.willuhn.logging.Logger;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Resource;

@Lifecycle(value=Lifecycle.Type.CONTEXT)
public class ScriptingSynchronizeJobProviderKontoauszug
implements ScriptingSynchronizeJobProvider {
    @Resource
    private ScriptingSynchronizeBackend backend = null;
    private static final List<Class<? extends SynchronizeJob>> JOBS = new ArrayList<Class<? extends SynchronizeJob>>(){
        {
            this.add(SynchronizeJobKontoauszug.class);
        }
    };

    @Override
    public List<SynchronizeJob> getSynchronizeJobs(Konto k) {
        Class<SynchronizeJobKontoauszug> type = SynchronizeJobKontoauszug.class;
        LinkedList<SynchronizeJob> jobs = new LinkedList<SynchronizeJob>();
        for (Konto kt : this.backend.getSynchronizeKonten(k)) {
            try {
                SynchronizeOptions options;
                if (!this.backend.supports(kt) || !this.backend.supports(type, k) || !(options = new SynchronizeOptions(kt)).getSyncKontoauszuege() && !options.getSyncSaldo()) continue;
                SynchronizeJobKontoauszug job = (SynchronizeJobKontoauszug)this.backend.create(type, kt);
                job.setContext("ctx.entity", kt);
                jobs.add(job);
            }
            catch (Exception e) {
                Logger.error((String)"unable to load synchronize jobs", (Throwable)e);
            }
        }
        return jobs;
    }

    @Override
    public boolean supports(Class<? extends SynchronizeJob> type, Konto k) {
        return true;
    }

    @Override
    public List<Class<? extends SynchronizeJob>> getJobTypes() {
        return JOBS;
    }

    public int compareTo(Object o) {
        return 1;
    }
}

