/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.util;

import de.willuhn.datasource.GenericIterator;
import de.willuhn.jameica.hbci.rmi.Umsatz;
import de.willuhn.jameica.hbci.server.Value;
import de.willuhn.jameica.util.DateUtil;
import java.rmi.RemoteException;
import java.util.Collection;
import java.util.Date;
import java.util.TreeMap;

public class SaldoFinder {
    private TreeMap<Date, Double> map = new TreeMap();
    private double anfangssaldo = 0.0;

    public SaldoFinder(GenericIterator umsaetze, double anfangssaldo) throws RemoteException {
        this.anfangssaldo = anfangssaldo;
        while (umsaetze.hasNext()) {
            Umsatz u = (Umsatz)umsaetze.next();
            if (u.hasFlag(2)) continue;
            this.map.put(u.getDatum(), u.getSaldo());
        }
    }

    public SaldoFinder(Collection<Value> values, double anfangssaldo) throws RemoteException {
        this.anfangssaldo = anfangssaldo;
        for (Value v : values) {
            this.map.put(v.getDate(), v.getValue());
        }
    }

    public Double get(Date date) {
        if (date == null) {
            return this.anfangssaldo;
        }
        Date key = DateUtil.startOfDay((Date)date);
        Double d = this.map.get(key);
        if (d != null) {
            return d;
        }
        Date lower = this.map.lowerKey(date);
        if (lower != null) {
            return this.map.get(lower);
        }
        return this.anfangssaldo;
    }
}

