/*
 * Decompiled with CFR 0.152.
 */
package io.konik;

import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public enum Configuration {
    INSTANCE;

    private static final Logger LOG;
    private final Properties properties = new Properties();

    private Configuration() {
        this.loadPropertiesFromFile();
        this.overwriteWithSystemProperties();
    }

    void reload() {
        this.loadPropertiesFromFile();
        this.overwriteWithSystemProperties();
    }

    private void loadPropertiesFromFile() {
        String fileName = Configuration.class.getName().toLowerCase();
        InputStream propertiesStream = ((Object)((Object)this)).getClass().getResourceAsStream("/" + fileName + ".properties");
        if (propertiesStream != null) {
            try {
                this.properties.load(propertiesStream);
            }
            catch (IOException e) {
                LOG.log(Level.CONFIG, "could not load properties file" + fileName + " from classpath", e);
            }
        }
    }

    private void overwriteWithSystemProperties() {
        for (Map.Entry<Object, Object> sysProperty : System.getProperties().entrySet()) {
            if (!(sysProperty.getKey() instanceof String) || !((String)sysProperty.getKey()).startsWith("io.konik")) continue;
            this.properties.put(sysProperty.getKey(), sysProperty.getValue());
        }
    }

    public String getProperty(String key) {
        return this.properties.getProperty(key);
    }

    public String getProperty(String key, String defaultValue) {
        return this.properties.getProperty(key, defaultValue);
    }

    public boolean stripTrailingZeros() {
        return Boolean.parseBoolean(this.getProperty("io.konik.stripTrailingZeros", "false"));
    }

    public String toString() {
        return "Konik Configuration dump\n" + this.properties.toString();
    }

    static {
        LOG = Logger.getLogger(Configuration.class.getName());
    }
}

