/*
 * Decompiled with CFR 0.152.
 */
package io.konik;

import io.konik.exception.TransformationException;
import io.konik.zugferd.Invoice;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.xml.sax.SAXException;

@Named
@Singleton
public class InvoiceTransformer {
    private static final Logger LOG = Logger.getLogger(InvoiceTransformer.class.getName());
    private static final String MARSHALLING_ERROR = "Marshalling error";
    private static final String KONIK_CONTEXT = "io.konik.zugferd";
    private final JAXBContext jaxbContext;

    public InvoiceTransformer() {
        try {
            this.jaxbContext = JAXBContext.newInstance((String)KONIK_CONTEXT);
        }
        catch (JAXBException e) {
            throw new TransformationException("Could not instantiate JaxB Context", e);
        }
    }

    InvoiceTransformer(JAXBContext jaxbContext) {
        this.jaxbContext = jaxbContext;
    }

    public Invoice toModel(InputStream xmlInputStream) {
        try {
            Unmarshaller unmarshaller = this.jaxbContext.createUnmarshaller();
            return (Invoice)unmarshaller.unmarshal((Source)new StreamSource(xmlInputStream), Invoice.class).getValue();
        }
        catch (JAXBException e) {
            throw new TransformationException(MARSHALLING_ERROR, e);
        }
    }

    public Invoice toModel(File file) {
        try {
            Unmarshaller unmarshaller = this.jaxbContext.createUnmarshaller();
            return (Invoice)((JAXBElement)unmarshaller.unmarshal(file)).getValue();
        }
        catch (JAXBException e) {
            throw new TransformationException(MARSHALLING_ERROR, e);
        }
    }

    public byte[] fromModel(Invoice invoice) {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream(16000);
        try {
            Marshaller marshaller = this.createMarshaller();
            marshaller.marshal((Object)invoice, (OutputStream)outputStream);
        }
        catch (JAXBException e) {
            throw new TransformationException(MARSHALLING_ERROR, e);
        }
        return outputStream.toByteArray();
    }

    public void fromModel(Invoice invoice, OutputStream outputStream) {
        try {
            Marshaller marshaller = this.createMarshaller();
            marshaller.marshal((Object)invoice, outputStream);
        }
        catch (JAXBException e) {
            throw new TransformationException(MARSHALLING_ERROR, e);
        }
    }

    public void fromModelAsync(final Invoice invoice, final OutputStream outputStream) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                InvoiceTransformer.this.fromModel(invoice, outputStream);
                try {
                    outputStream.flush();
                    outputStream.close();
                }
                catch (IOException e) {
                    LOG.log(Level.WARNING, "Faild to Transform Model", e);
                }
            }
        }).start();
    }

    public Validator getZfSchemaValidator() throws SAXException {
        SchemaFactory sf = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        URL schemaInvoice = InvoiceTransformer.class.getResource("/zfSchema/ZUGFeRD_1p0.xsd");
        Schema invoiceSchema = sf.newSchema(schemaInvoice);
        return invoiceSchema.newValidator();
    }

    private Marshaller createMarshaller() throws JAXBException {
        Marshaller marshaller = this.jaxbContext.createMarshaller();
        marshaller.setProperty("jaxb.formatted.output", (Object)this.formatXmlOutput());
        return marshaller;
    }

    protected Boolean formatXmlOutput() {
        return Boolean.FALSE;
    }
}

