/*
 * Decompiled with CFR 0.152.
 */
package io.konik;

import com.google.common.collect.Lists;
import io.konik.InvoiceTransformer;
import io.konik.csv.pdf.FileAppenderPriorityComparator;
import io.konik.harness.AppendParameter;
import io.konik.harness.FileAppender;
import io.konik.harness.FileExtractor;
import io.konik.harness.appender.DefaultAppendParameter;
import io.konik.harness.exception.InvoiceAppendError;
import io.konik.zugferd.Invoice;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.ServiceLoader;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;

@Named
@Singleton
public class PdfHandler {
    private static final Logger LOG = Logger.getLogger(PdfHandler.class.getName());
    private final FileAppender fileAppender;
    private final FileExtractor fileExtractor;
    private final InvoiceTransformer transformer;

    @Inject
    public PdfHandler(FileAppender fileAppender, FileExtractor fileExtractor, InvoiceTransformer transformer) {
        this.fileAppender = fileAppender;
        this.fileExtractor = fileExtractor;
        this.transformer = transformer;
    }

    public PdfHandler() {
        Iterator<FileAppender> iterator = ServiceLoader.load(FileAppender.class).iterator();
        ArrayList appenders = Lists.newArrayList(iterator);
        if (appenders.isEmpty()) {
            throw new IllegalStateException("FileAppender implementation not found in the classpath!");
        }
        Collections.sort(appenders, new FileAppenderPriorityComparator(FileAppenderPriorityComparator.Order.DESC));
        this.fileAppender = (FileAppender)appenders.get(0);
        this.fileExtractor = ServiceLoader.load(FileExtractor.class).iterator().next();
        this.transformer = new InvoiceTransformer();
    }

    public void appendInvoice(Invoice invoice, InputStream inputPdf, OutputStream resultingPdf) {
        try {
            this.append(invoice, inputPdf, resultingPdf);
        }
        catch (IOException e) {
            throw new InvoiceAppendError("Not able to append invoice to PDF", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void append(Invoice invoice, InputStream inputPdf, OutputStream resultingPdf) throws IOException {
        PipedOutputStream pipedOutputStream = new PipedOutputStream();
        PipedInputStream pipedInputStream = new PipedInputStream(pipedOutputStream, 65536);
        try {
            String version = invoice.getContext().getGuideline().getVersion().versionAlt();
            String confomanceLevel = invoice.getContext().getGuideline().getConformanceLevel().name();
            this.transformer.fromModelAsync(invoice, pipedOutputStream);
            DefaultAppendParameter parameter = new DefaultAppendParameter(inputPdf, (InputStream)pipedInputStream, resultingPdf, version, confomanceLevel);
            this.fileAppender.append((AppendParameter)parameter);
        }
        finally {
            pipedInputStream.close();
        }
    }

    private void appendSync(Invoice invoice, InputStream inputPdf, OutputStream resultingPdf) {
        String version = invoice.getContext().getGuideline().getVersion().versionAlt();
        String confomanceLevel = invoice.getContext().getGuideline().getConformanceLevel().name();
        byte[] invoiceModel = this.transformer.fromModel(invoice);
        DefaultAppendParameter parameter = new DefaultAppendParameter(inputPdf, (InputStream)new ByteArrayInputStream(invoiceModel), resultingPdf, version, confomanceLevel);
        this.fileAppender.append((AppendParameter)parameter);
    }

    public Invoice extractInvoice(File pdfFile) throws FileNotFoundException {
        byte[] xmlInvoice = this.fileExtractor.extract((InputStream)new FileInputStream(pdfFile));
        return this.transformer.toModel(new ByteArrayInputStream(xmlInvoice));
    }

    public Invoice extractInvoice(InputStream pdfInputStream) {
        InputStream invoiceInputStream = this.fileExtractor.extractToStream(pdfInputStream);
        Invoice invoiceModel = this.transformer.toModel(invoiceInputStream);
        PdfHandler.closeQuietly(invoiceInputStream);
        return invoiceModel;
    }

    private static void closeQuietly(InputStream stream) {
        try {
            if (stream != null) {
                stream.close();
            }
        }
        catch (IOException e) {
            LOG.log(Level.WARNING, "Could not close InputStream. This can be a memory leak as the PDF might still be open.", e);
        }
    }
}

