/*
 * Decompiled with CFR 0.152.
 */
package io.konik.calculation;

import io.konik.calculation.Correction;
import io.konik.calculation.InvoiceMonetarySummationAndTradeTaxCompleter;
import io.konik.calculation.ItemSpecifiedMonetarySummationCompleter;
import io.konik.util.Invoices;
import io.konik.zugferd.Invoice;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.validation.constraints.NotNull;

public final class InvoiceCalculator {
    private final Invoice invoice;
    private final List<Correction<Invoice>> corrections = new CopyOnWriteArrayList<Correction<Invoice>>();

    public InvoiceCalculator(@NotNull Invoice invoice) {
        this.invoice = invoice;
        this.corrections.add(new InvoiceMonetarySummationAndTradeTaxCompleter());
        this.corrections.add(new ItemSpecifiedMonetarySummationCompleter());
    }

    public void applyCorrection(Correction<Invoice> correction) {
        this.corrections.add(correction);
    }

    public void reset() {
        this.corrections.clear();
    }

    public Invoice complete() {
        Invoice correctedInvoice = Invoices.clone(this.invoice);
        for (Correction<Invoice> correction : this.corrections) {
            correctedInvoice = correction.correct(correctedInvoice);
        }
        return correctedInvoice;
    }
}

