/*
 * Decompiled with CFR 0.152.
 */
package io.konik.calculation;

import io.konik.calculation.Correction;
import io.konik.validation.AmountCalculator;
import io.konik.zugferd.Invoice;
import io.konik.zugferd.entity.trade.MonetarySummation;
import io.konik.zugferd.entity.trade.TradeTax;
import java.util.List;
import javax.validation.constraints.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class InvoiceMonetarySummationAndTradeTaxCompleter
implements Correction<Invoice> {
    protected static Logger log = LoggerFactory.getLogger(InvoiceMonetarySummationAndTradeTaxCompleter.class);

    @Override
    public Invoice correct(@NotNull Invoice invoice) {
        log.debug("Running InvoiceMonetarySummationCompleter...");
        if (invoice.getTrade() != null && invoice.getTrade().getSettlement() != null) {
            AmountCalculator.RecalculationResult result = AmountCalculator.recalculate(invoice);
            MonetarySummation monetarySummation = result.getMonetarySummation();
            invoice.getTrade().getSettlement().setMonetarySummation(monetarySummation);
            AmountCalculator.TaxAggregator taxAggregator = result.getTaxAggregator();
            List<TradeTax> taxes = taxAggregator.generateTradeTaxList(invoice.getTrade().getSettlement().getCurrency(), invoice.getTrade().getSettlement().getTradeTax());
            invoice.getTrade().getSettlement().getTradeTax().clear();
            for (TradeTax tradeTax : taxes) {
                invoice.getTrade().getSettlement().addTradeTax(tradeTax);
            }
        }
        return invoice;
    }
}

