/*
 * Decompiled with CFR 0.152.
 */
package io.konik.calculation;

import io.konik.calculation.Correction;
import io.konik.util.Items;
import io.konik.validation.AmountCalculator;
import io.konik.zugferd.Invoice;
import io.konik.zugferd.entity.trade.item.Item;
import io.konik.zugferd.entity.trade.item.SpecifiedMonetarySummation;
import java.util.List;
import javax.validation.constraints.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ItemSpecifiedMonetarySummationCompleter
implements Correction<Invoice> {
    protected static Logger log = LoggerFactory.getLogger(ItemSpecifiedMonetarySummationCompleter.class);

    @Override
    public Invoice correct(@NotNull Invoice invoice) {
        log.debug("Running ItemSpecifiedMonetarySummationCompleter...");
        if (invoice.getTrade() != null && invoice.getTrade().getItems() != null) {
            List<Item> items = Items.purchasableItemsOnly(invoice.getTrade().getItems());
            for (Item item : items) {
                if (item.getSettlement() == null) continue;
                SpecifiedMonetarySummation monetarySummation = AmountCalculator.calculateSpecifiedMonetarySummation(item);
                item.getSettlement().setMonetarySummation(monetarySummation);
            }
        }
        return invoice;
    }
}

