/*
 * Decompiled with CFR 0.152.
 */
package io.konik.csv.converter;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.neovisionaries.i18n.CurrencyCode;
import io.konik.csv.model.Row;
import io.konik.zugferd.Invoice;
import io.konik.zugferd.entity.Address;
import io.konik.zugferd.entity.Contact;
import io.konik.zugferd.entity.Header;
import io.konik.zugferd.entity.Note;
import io.konik.zugferd.entity.PaymentMeans;
import io.konik.zugferd.entity.TaxRegistration;
import io.konik.zugferd.entity.TradeParty;
import io.konik.zugferd.entity.trade.Agreement;
import io.konik.zugferd.entity.trade.Settlement;
import io.konik.zugferd.entity.trade.Trade;
import io.konik.zugferd.entity.trade.item.Item;
import io.konik.zugferd.entity.trade.item.SpecifiedAgreement;
import io.konik.zugferd.entity.trade.item.SpecifiedDelivery;
import io.konik.zugferd.entity.trade.item.SpecifiedSettlement;
import io.konik.zugferd.entity.trade.item.SpecifiedTax;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

public final class InvoiceToRowConverter {
    public static Row convert(Invoice invoice) {
        if (invoice == null) {
            throw new IllegalArgumentException("Invoice cannot be null");
        }
        return new Process().run(invoice);
    }

    private static class Process {
        private Process() {
        }

        public Row run(Invoice invoice) {
            Row row = new Row();
            row.setHeader(Process.mapHeader(invoice));
            Trade trade = invoice.getTrade();
            if (trade != null) {
                Settlement settlement;
                Agreement agreement = trade.getAgreement();
                if (agreement != null) {
                    if (agreement.getBuyer() != null) {
                        row.setRecipient(Process.mapTradeParty(agreement.getBuyer()));
                    } else {
                        row.setRecipient(new Row.TradeParty());
                    }
                    if (agreement.getSeller() != null) {
                        row.setIssuer(Process.mapTradeParty(agreement.getSeller()));
                    } else {
                        row.setIssuer(new Row.TradeParty());
                    }
                }
                if ((settlement = trade.getSettlement()) != null && settlement.getPaymentMeans() != null && !settlement.getPaymentMeans().isEmpty()) {
                    PaymentMeans paymentMeans = settlement.getPaymentMeans().get(0);
                    if (paymentMeans.getInformations() != null && !paymentMeans.getInformations().isEmpty()) {
                        row.setComments(paymentMeans.getInformations().get(0));
                    }
                    Row.BankInformation bankInformation = new Row.BankInformation();
                    if (paymentMeans.getPayeeAccount() != null) {
                        bankInformation.setIban(paymentMeans.getPayeeAccount().getIban());
                    }
                    if (paymentMeans.getPayeeInstitution() != null) {
                        bankInformation.setBankName(paymentMeans.getPayeeInstitution().getName()).setBic(paymentMeans.getPayeeInstitution().getBic());
                    }
                    row.getIssuer().setBankInfo(bankInformation);
                }
                List items = Lists.transform(trade.getItems(), (Function)new Function<Item, Row.Item>(){

                    @Nullable
                    public Row.Item apply(@Nullable Item item) {
                        Row.Item rowItem = new Row.Item();
                        if (item != null) {
                            SpecifiedSettlement settlement;
                            SpecifiedAgreement agreement;
                            rowItem.setName(item.getProduct() != null ? item.getProduct().getName() : "");
                            SpecifiedDelivery delivery = item.getDelivery();
                            if (delivery != null && delivery.getBilled() != null) {
                                rowItem.setQuantity(delivery.getBilled().getValue()).setUnit(delivery.getBilled().getUnit());
                            }
                            if ((agreement = item.getAgreement()) != null && agreement.getNetPrice() != null) {
                                rowItem.setUnitPrice(agreement.getNetPrice().getChargeAmount().getValue());
                            }
                            if ((settlement = item.getSettlement()) != null && settlement.getTradeTax() != null && !settlement.getTradeTax().isEmpty()) {
                                SpecifiedTax tradeTax = settlement.getTradeTax().get(0);
                                rowItem.setTaxPercent(tradeTax.getPercentage());
                            }
                        }
                        return rowItem;
                    }
                });
                row.setItems(items);
            }
            return row;
        }

        private static Row.TradeParty mapTradeParty(TradeParty tradeParty) {
            List<TaxRegistration> taxRegistrations;
            Contact contact;
            Row.TradeParty rowTradeParty = new Row.TradeParty();
            rowTradeParty.setName(tradeParty.getName());
            Address address = tradeParty.getAddress();
            if (Objects.nonNull(address)) {
                rowTradeParty.setAddressLine1(address.getLineOne()).setAddressLine2(address.getLineTwo()).setCity(address.getCity()).setCountryCode(address.getCountry()).setPostcode(address.getPostcode());
            }
            if (Objects.nonNull(contact = tradeParty.getContact())) {
                rowTradeParty.setContactName(contact.getName()).setEmail(contact.getEmail());
            }
            if (Objects.nonNull(taxRegistrations = tradeParty.getTaxRegistrations()) && !taxRegistrations.isEmpty()) {
                rowTradeParty.setTaxes(Lists.transform(taxRegistrations, (Function)new Function<TaxRegistration, Row.Tax>(){

                    @Nullable
                    public Row.Tax apply(TaxRegistration taxRegistration) {
                        Row.Tax tax = new Row.Tax();
                        if (Objects.nonNull(taxRegistration)) {
                            tax.setNumber(taxRegistration.getTaxNumber()).setType(taxRegistration.getType());
                        }
                        return tax;
                    }
                }));
            }
            return rowTradeParty;
        }

        private static Row.Header mapHeader(Invoice invoice) {
            Header header = invoice.getHeader();
            if (Objects.nonNull(header)) {
                Note note;
                CurrencyCode currencyCode = null;
                String paymentReference = null;
                String customerNumber = null;
                String noteText = null;
                Trade trade = invoice.getTrade();
                if (trade != null) {
                    TradeParty buyer;
                    Settlement settlement = trade.getSettlement();
                    Agreement agreement = trade.getAgreement();
                    if (settlement != null) {
                        currencyCode = settlement.getCurrency();
                        paymentReference = settlement.getPaymentReference();
                    }
                    if (agreement != null && (buyer = agreement.getBuyer()) != null) {
                        customerNumber = buyer.getId();
                    }
                }
                if (header.getNotes() != null && !header.getNotes().isEmpty() && (note = header.getNotes().get(0)) != null && note.getContents() != null && !note.getContents().isEmpty()) {
                    noteText = note.getContents().get(0);
                }
                Date issued = header.getIssued() != null ? new Date(header.getIssued().getTime()) : null;
                Date dueDate = header.getContractualDueDate() != null ? new Date(header.getContractualDueDate().getTime()) : null;
                return new Row.Header().setInvoiceNumber(header.getInvoiceNumber()).setType(header.getName()).setCurrency(currencyCode).setReference(paymentReference).setCustomerNumber(customerNumber).setIssued(issued).setDueDate(dueDate).setNote(noteText);
            }
            return new Row.Header();
        }
    }
}

