/*
 * Decompiled with CFR 0.152.
 */
package io.konik.csv.converter;

import com.google.common.base.Function;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.neovisionaries.i18n.CurrencyCode;
import io.konik.csv.model.Row;
import io.konik.zugferd.Invoice;
import io.konik.zugferd.entity.Address;
import io.konik.zugferd.entity.Contact;
import io.konik.zugferd.entity.CreditorFinancialAccount;
import io.konik.zugferd.entity.FinancialInstitution;
import io.konik.zugferd.entity.GrossPrice;
import io.konik.zugferd.entity.Header;
import io.konik.zugferd.entity.Note;
import io.konik.zugferd.entity.PaymentMeans;
import io.konik.zugferd.entity.PositionDocument;
import io.konik.zugferd.entity.Price;
import io.konik.zugferd.entity.Product;
import io.konik.zugferd.entity.TaxRegistration;
import io.konik.zugferd.entity.TradeParty;
import io.konik.zugferd.entity.trade.Agreement;
import io.konik.zugferd.entity.trade.Delivery;
import io.konik.zugferd.entity.trade.MonetarySummation;
import io.konik.zugferd.entity.trade.Settlement;
import io.konik.zugferd.entity.trade.Trade;
import io.konik.zugferd.entity.trade.TradeTax;
import io.konik.zugferd.entity.trade.item.Item;
import io.konik.zugferd.entity.trade.item.ItemTax;
import io.konik.zugferd.entity.trade.item.SpecifiedAgreement;
import io.konik.zugferd.entity.trade.item.SpecifiedDelivery;
import io.konik.zugferd.entity.trade.item.SpecifiedMonetarySummation;
import io.konik.zugferd.entity.trade.item.SpecifiedSettlement;
import io.konik.zugferd.profile.ConformanceLevel;
import io.konik.zugferd.unece.codes.DocumentCode;
import io.konik.zugferd.unece.codes.TaxCategory;
import io.konik.zugferd.unece.codes.TaxCode;
import io.konik.zugferd.unece.codes.UnitOfMeasurement;
import io.konik.zugferd.unqualified.Amount;
import io.konik.zugferd.unqualified.Quantity;
import io.konik.zugferd.unqualified.ZfDateDay;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nullable;

public class RowToInvoiceConverter {
    private static final ConcurrentMap<String, DocumentCode> codes = new ConcurrentHashMap<String, DocumentCode>();

    public static Invoice convert(Row row) {
        Objects.requireNonNull(row);
        return new Process().run(row);
    }

    protected static DocumentCode getCode(String code) {
        String key;
        if (code != null && codes.containsKey(key = code.trim().toLowerCase())) {
            return (DocumentCode)((Object)codes.get(key));
        }
        return DocumentCode._380;
    }

    static {
        codes.put("rechnung", DocumentCode._380);
        codes.put("gutschriftsanzeige", DocumentCode._380);
        codes.put("angebot", DocumentCode._310);
        codes.put("bestellung", DocumentCode._220);
        codes.put("proformarechnung", DocumentCode._325);
        codes.put("teilrechnung", DocumentCode._326);
        codes.put("korrigierte rechnung", DocumentCode._384);
        codes.put("konsolidierte rechnung", DocumentCode._385);
        codes.put("vorauszahlungsrechnung", DocumentCode._386);
        codes.put("invoice", DocumentCode._380);
        codes.put("credit note", DocumentCode._381);
        codes.put("offer", DocumentCode._310);
        codes.put("order", DocumentCode._220);
        codes.put("proforma invoice", DocumentCode._325);
        codes.put("partial invoice", DocumentCode._326);
        codes.put("corrected invoice", DocumentCode._384);
        codes.put("consolidated invoice", DocumentCode._385);
        codes.put("prepayment invoice", DocumentCode._386);
    }

    private static class Process {
        private CurrencyCode currencyCode;
        private String customerNumber;
        private ConcurrentMap<BigDecimal, TaxAccumulator> calculatedTax = new ConcurrentHashMap<BigDecimal, TaxAccumulator>();

        private Process() {
        }

        protected Invoice run(Row row) {
            Header header = this.mapHeader(row.getHeader());
            TradeParty buyer = this.mapTradeParty(row.getRecipient());
            TradeParty seller = this.mapTradeParty(row.getIssuer());
            Agreement agreement = new Agreement().setBuyer(buyer).setSeller(seller);
            Delivery delivery = new Delivery(header.getIssued());
            Settlement settlement = this.mapSettlement(row);
            Trade trade = this.createTrade(row, agreement, delivery, settlement);
            Invoice invoice = new Invoice(ConformanceLevel.EXTENDED);
            invoice.setHeader(header);
            invoice.setTrade(trade);
            return invoice;
        }

        private Trade createTrade(Row row, Agreement agreement, Delivery delivery, Settlement settlement) {
            Trade trade = new Trade().setAgreement(agreement).setDelivery(delivery).setSettlement(settlement);
            for (Item item : this.transformToItems(row.getItems())) {
                trade.addItem(item);
            }
            return trade;
        }

        private Settlement mapSettlement(Row row) {
            Row.BankInformation bankInformation = row.getIssuer().getBankInfo();
            PaymentMeans paymentMeans = new PaymentMeans().addInformation(row.getComments()).setPayeeAccount(new CreditorFinancialAccount(bankInformation.getIban())).setPayeeInstitution(new FinancialInstitution(bankInformation.getBic()).setName(bankInformation.getBankName()));
            this.computeCalculatedTax(row);
            Settlement settlement = new Settlement().setCurrency(this.currencyCode).addPaymentMeans(paymentMeans).setPaymentReference(row.getHeader().getReference()).setMonetarySummation(this.calculateMonetarySummation());
            this.addTradeTaxesFromCalculatedTax(settlement);
            return settlement;
        }

        private MonetarySummation calculateMonetarySummation() {
            MonetarySummation monetarySummation = new MonetarySummation().setLineTotal(new Amount(BigDecimal.ZERO, this.currencyCode)).setChargeTotal(new Amount(BigDecimal.ZERO, this.currencyCode)).setAllowanceTotal(new Amount(BigDecimal.ZERO, this.currencyCode)).setTaxBasisTotal(new Amount(BigDecimal.ZERO, this.currencyCode)).setTaxTotal(new Amount(BigDecimal.ZERO, this.currencyCode)).setGrandTotal(new Amount(BigDecimal.ZERO, this.currencyCode));
            for (Map.Entry entry : this.calculatedTax.entrySet()) {
                BigDecimal lineTotal = monetarySummation.getLineTotal().getValue();
                BigDecimal taxBasisTotal = monetarySummation.getTaxBasisTotal().getValue();
                BigDecimal taxTotal = monetarySummation.getTaxTotal().getValue();
                BigDecimal grandTotal = monetarySummation.getGrandTotal().getValue();
                BigDecimal curLineTotal = ((TaxAccumulator)entry.getValue()).lineTotal;
                BigDecimal curTaxAmount = ((TaxAccumulator)entry.getValue()).taxAmount;
                monetarySummation.setLineTotal(new Amount(lineTotal.add(curLineTotal), this.currencyCode));
                monetarySummation.setTaxBasisTotal(new Amount(taxBasisTotal.add(curLineTotal), this.currencyCode));
                monetarySummation.setTaxTotal(new Amount(taxTotal.add(curTaxAmount), this.currencyCode));
                monetarySummation.setGrandTotal(new Amount(grandTotal.add(curTaxAmount).add(curLineTotal), this.currencyCode));
            }
            return monetarySummation;
        }

        private void addTradeTaxesFromCalculatedTax(Settlement settlement) {
            for (Map.Entry entry : this.calculatedTax.entrySet()) {
                BigDecimal lineTotal = ((TaxAccumulator)entry.getValue()).lineTotal;
                BigDecimal taxAmount = ((TaxAccumulator)entry.getValue()).taxAmount;
                TradeTax tradeTax = new TradeTax().setType(TaxCode.VAT).setPercentage((BigDecimal)entry.getKey()).setCategory(TaxCategory.S).setBasis(new Amount(lineTotal, this.currencyCode)).setCalculated(new Amount(taxAmount, this.currencyCode));
                tradeTax.setLineTotal(new Amount(lineTotal, this.currencyCode));
                settlement.addTradeTax(tradeTax);
            }
        }

        private void computeCalculatedTax(Row row) {
            for (Row.Item item : row.getItems()) {
                if (item == null) continue;
                BigDecimal percent = item.getTaxPercent();
                BigDecimal unitPrice = item.getUnitPrice();
                BigDecimal quantity = item.getQuantity();
                if (unitPrice == null || percent == null || quantity == null) continue;
                BigDecimal lineTotal = unitPrice.multiply(quantity);
                BigDecimal taxAmount = lineTotal.multiply(percent.divide(BigDecimal.valueOf(100L), 2, RoundingMode.HALF_UP));
                TaxAccumulator taxAccumulator = new TaxAccumulator(taxAmount, lineTotal);
                if (this.calculatedTax.containsKey(percent)) {
                    taxAccumulator = ((TaxAccumulator)this.calculatedTax.get(percent)).accumulate(taxAccumulator);
                }
                this.calculatedTax.put(percent, taxAccumulator);
            }
        }

        private Header mapHeader(Row.Header rowHeader) {
            Header header = new Header();
            if (rowHeader != null) {
                if (rowHeader.getIssued() != null) {
                    header.setIssued(new ZfDateDay(rowHeader.getIssued()));
                }
                if (rowHeader.getDueDate() != null) {
                    header.setContractualDueDate(new ZfDateDay(rowHeader.getDueDate()));
                }
                header.setCode(RowToInvoiceConverter.getCode(rowHeader.getType())).setInvoiceNumber(rowHeader.getInvoiceNumber()).setName(rowHeader.getType());
                if (!Strings.isNullOrEmpty((String)rowHeader.getNote())) {
                    header.addNote(new Note(rowHeader.getNote()));
                }
                this.currencyCode = rowHeader.getCurrency();
                this.customerNumber = rowHeader.getCustomerNumber();
            }
            return header;
        }

        private TradeParty mapTradeParty(Row.TradeParty tradeParty) {
            TradeParty recipient = new TradeParty();
            if (tradeParty != null) {
                recipient.setName(tradeParty.getName()).setId(this.customerNumber).setContact(this.mapContact(tradeParty)).setAddress(this.mapAddress(tradeParty));
                if (tradeParty.getTaxes() != null) {
                    List<TaxRegistration> taxRegistrations = this.mapTaxRegistrations(tradeParty.getTaxes());
                    TaxRegistration[] array = new TaxRegistration[tradeParty.getTaxes().size()];
                    recipient.addTaxRegistrations(taxRegistrations.toArray(array));
                }
            }
            return recipient;
        }

        private List<TaxRegistration> mapTaxRegistrations(List<Row.Tax> taxes) {
            return Lists.transform(taxes, (Function)new Function<Row.Tax, TaxRegistration>(){

                @Nullable
                public TaxRegistration apply(Row.Tax tax) {
                    return new TaxRegistration(tax.getNumber(), tax.getType());
                }
            });
        }

        private Contact mapContact(Row.TradeParty tradeParty) {
            return new Contact(tradeParty.getContactName(), null, null, null, tradeParty.getEmail());
        }

        private Address mapAddress(Row.TradeParty tradeParty) {
            return new Address(tradeParty.getPostcode(), tradeParty.getAddressLine1(), tradeParty.getAddressLine2(), tradeParty.getCity(), tradeParty.getCountryCode());
        }

        private List<Item> transformToItems(List<Row.Item> items) {
            final AtomicInteger index = new AtomicInteger(0);
            return Lists.transform(items, (Function)new Function<Row.Item, Item>(){

                public Item apply(Row.Item rowItem) {
                    Item item = new Item();
                    if (rowItem != null) {
                        String assignedId = String.format("%d", index.incrementAndGet());
                        Product product = this.mapProduct(assignedId, rowItem);
                        SpecifiedDelivery delivery = this.mapDelivery(rowItem);
                        SpecifiedSettlement settlement = this.mapSettlement(rowItem);
                        SpecifiedAgreement agreement = this.mapAgreement(rowItem);
                        item.setPosition(new PositionDocument(assignedId));
                        item.setProduct(product);
                        item.setDelivery(delivery);
                        item.setSettlement(settlement);
                        item.setAgreement(agreement);
                    }
                    return item;
                }

                private SpecifiedAgreement mapAgreement(Row.Item rowItem) {
                    SpecifiedAgreement agreement = new SpecifiedAgreement();
                    agreement.setNetPrice(new Price(new Amount(rowItem.getUnitPrice(), Process.this.currencyCode)));
                    agreement.setGrossPrice(new GrossPrice(new Amount(rowItem.getUnitPrice(), Process.this.currencyCode)));
                    return agreement;
                }

                private SpecifiedSettlement mapSettlement(Row.Item rowItem) {
                    ItemTax itemTax = this.mapItemTax(rowItem);
                    SpecifiedMonetarySummation monetarySummation = this.mapMonetarySummation(rowItem);
                    SpecifiedSettlement settlement = new SpecifiedSettlement();
                    settlement.addTradeTax(itemTax);
                    settlement.setMonetarySummation(monetarySummation);
                    return settlement;
                }

                private SpecifiedMonetarySummation mapMonetarySummation(Row.Item rowItem) {
                    BigDecimal lineTotal = BigDecimal.ZERO;
                    if (rowItem.getUnitPrice() != null && rowItem.getQuantity() != null) {
                        lineTotal = rowItem.getUnitPrice().multiply(rowItem.getQuantity());
                    }
                    SpecifiedMonetarySummation monetarySummation = new SpecifiedMonetarySummation();
                    monetarySummation.setLineTotal(new Amount(lineTotal, Process.this.currencyCode));
                    return monetarySummation;
                }

                private ItemTax mapItemTax(Row.Item rowItem) {
                    ItemTax itemTax = new ItemTax().setType(TaxCode.VAT);
                    BigDecimal percent = rowItem.getTaxPercent() != null ? rowItem.getTaxPercent() : BigDecimal.ZERO;
                    itemTax.setPercentage(percent);
                    itemTax.setCategory(TaxCategory.S);
                    return itemTax;
                }

                private SpecifiedDelivery mapDelivery(Row.Item rowItem) {
                    SpecifiedDelivery delivery = new SpecifiedDelivery();
                    BigDecimal quantity = rowItem.getQuantity() != null ? rowItem.getQuantity() : BigDecimal.ZERO;
                    UnitOfMeasurement unit = rowItem.getUnit() != null ? rowItem.getUnit() : UnitOfMeasurement.UNIT;
                    delivery.setBilled(new Quantity(quantity, unit));
                    return delivery;
                }

                private Product mapProduct(String assignedId, Row.Item rowItem) {
                    return new Product().setName(rowItem.getName()).setBuyerAssignedId(assignedId).setSellerAssignedId(assignedId);
                }
            });
        }

        private static class TaxAccumulator {
            public final BigDecimal taxAmount;
            public final BigDecimal lineTotal;

            public TaxAccumulator(BigDecimal taxAmount, BigDecimal lineTotal) {
                this.taxAmount = taxAmount;
                this.lineTotal = lineTotal;
            }

            public TaxAccumulator accumulate(TaxAccumulator taxAccumulator) {
                return new TaxAccumulator(taxAccumulator.taxAmount.add(this.taxAmount), taxAccumulator.lineTotal.add(this.lineTotal));
            }
        }
    }
}

