/*
 * Decompiled with CFR 0.152.
 */
package io.konik.csv.mapper;

import io.konik.csv.converter.RowToInvoiceConverter;
import io.konik.csv.mapper.ColumnsConfigurer;
import io.konik.csv.mapper.CsvMapperBuilder;
import io.konik.csv.mapper.CsvMapperHeaderColumnsConfigurer;
import io.konik.csv.model.Row;
import io.konik.zugferd.Invoice;
import java.io.File;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.supercsv.cellprocessor.ift.CellProcessor;
import org.supercsv.io.dozer.CsvDozerBeanReader;

public class CsvInvoicesReader {
    private static final Logger log = LoggerFactory.getLogger(CsvInvoicesReader.class);
    private final ColumnsConfigurer columnsConfigurer;

    public CsvInvoicesReader() {
        this(new CsvMapperHeaderColumnsConfigurer());
    }

    public CsvInvoicesReader(ColumnsConfigurer columnsConfigurer) {
        this.columnsConfigurer = columnsConfigurer;
    }

    public Result read(File csvFile) {
        CsvMapperBuilder mapperBuilder = CsvMapperBuilder.withHeadersFromCsvFile(csvFile, this.columnsConfigurer);
        CellProcessor[] processors = mapperBuilder.getCellProcessors();
        CsvDozerBeanReader reader = mapperBuilder.getBeanReader(csvFile, Row.class);
        LinkedList<ConvertedRow> convertedRows = new LinkedList<ConvertedRow>();
        LinkedList<RowError> rowErrors = new LinkedList<RowError>();
        Row currentRow = null;
        AtomicInteger rowNumber = new AtomicInteger(1);
        try {
            do {
                try {
                    currentRow = (Row)reader.read(Row.class, processors);
                    if (currentRow == null) continue;
                    Invoice invoice = RowToInvoiceConverter.convert(currentRow);
                    convertedRows.add(new ConvertedRow(rowNumber.getAndIncrement(), currentRow, invoice));
                }
                catch (Exception e) {
                    log.warn("Exception caught during reading a row");
                    rowErrors.add(new RowError(rowNumber.getAndIncrement(), currentRow, e.getMessage(), e));
                }
            } while (currentRow != null);
            Result e = new Result(convertedRows, rowErrors);
            return e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    log.error(e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    public static class Result {
        private final List<ConvertedRow> convertedRows;
        private final List<RowError> rowErrors;

        public Result(List<ConvertedRow> convertedRows, List<RowError> rowErrors) {
            this.convertedRows = convertedRows;
            this.rowErrors = rowErrors;
        }

        public List<ConvertedRow> getConvertedRows() {
            return this.convertedRows;
        }

        public List<RowError> getRowErrors() {
            return this.rowErrors;
        }
    }

    public static class RowError {
        private final int rowNumber;
        private final Row row;
        private final String errorMessage;
        private final Exception exception;

        public RowError(int rowNumber, Row row, String errorMessage, Exception exception) {
            this.rowNumber = rowNumber;
            this.row = row;
            this.errorMessage = errorMessage;
            this.exception = exception;
        }

        public int getRowNumber() {
            return this.rowNumber;
        }

        public Row getRow() {
            return this.row;
        }

        public String getErrorMessage() {
            return this.errorMessage;
        }

        public Exception getException() {
            return this.exception;
        }
    }

    public static class ConvertedRow {
        private final int rowNumber;
        private final Row row;
        private final Invoice invoice;

        public ConvertedRow(int rowNumber, Row row, Invoice invoice) {
            this.rowNumber = rowNumber;
            this.row = row;
            this.invoice = invoice;
        }

        public int getRowNumber() {
            return this.rowNumber;
        }

        public Row getRow() {
            return this.row;
        }

        public Invoice getInvoice() {
            return this.invoice;
        }
    }
}

