/*
 * Decompiled with CFR 0.152.
 */
package io.konik.csv.mapper;

import com.google.common.base.Function;
import com.neovisionaries.i18n.CountryCode;
import com.neovisionaries.i18n.CurrencyCode;
import io.konik.csv.mapper.ColumnsConfigurer;
import io.konik.csv.mapper.CsvMapperBuilder;
import io.konik.csv.processor.DateProcessor;
import io.konik.csv.processor.ReferenceProcessor;
import io.konik.csv.processor.UnitOfMeasurementProcessor;
import io.konik.zugferd.unece.codes.Reference;
import io.konik.zugferd.unece.codes.UnitOfMeasurement;
import java.math.BigDecimal;
import java.util.Date;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.supercsv.cellprocessor.ift.CellProcessor;

final class CsvMapperHeaderColumnsConfigurer
implements ColumnsConfigurer {
    private static final Logger log = LoggerFactory.getLogger(CsvMapperHeaderColumnsConfigurer.class);
    private static final ConcurrentMap<Pattern, Function<String, CsvMapperBuilder.Column.Builder>> config = new ConcurrentHashMap<Pattern, Function<String, CsvMapperBuilder.Column.Builder>>();

    CsvMapperHeaderColumnsConfigurer() {
    }

    private static Function<String, CsvMapperBuilder.Column.Builder> defaultColumn() {
        return new Function<String, CsvMapperBuilder.Column.Builder>(){

            @Nullable
            public CsvMapperBuilder.Column.Builder apply(String input) {
                log.debug("Creating default column for {}", (Object)input);
                return CsvMapperBuilder.column(input);
            }
        };
    }

    private static Function<String, CsvMapperBuilder.Column.Builder> typeColumn(final Class<?> type, final CellProcessor processor) {
        return new Function<String, CsvMapperBuilder.Column.Builder>(){

            @Nullable
            public CsvMapperBuilder.Column.Builder apply(@Nullable String input) {
                CsvMapperBuilder.Column.Builder builder = CsvMapperBuilder.column(input).type(type);
                if (processor != null) {
                    builder.processor(processor);
                }
                return builder;
            }
        };
    }

    private static Function<String, CsvMapperBuilder.Column.Builder> typeColumn(Class<?> type) {
        return CsvMapperHeaderColumnsConfigurer.typeColumn(type, null);
    }

    @Override
    public CsvMapperBuilder.Column getColumnDefinitionForHeader(String header) {
        for (Pattern pattern : config.keySet()) {
            Matcher matcher = pattern.matcher(header);
            while (matcher.find()) {
                String value = matcher.group();
                CsvMapperBuilder.Column.Builder builder = (CsvMapperBuilder.Column.Builder)((Function)config.get(pattern)).apply((Object)value);
                if (builder == null) continue;
                return builder.build();
            }
        }
        return null;
    }

    static {
        config.put(Pattern.compile("^file\\.input"), CsvMapperHeaderColumnsConfigurer.defaultColumn());
        config.put(Pattern.compile("^file\\.output"), CsvMapperHeaderColumnsConfigurer.defaultColumn());
        config.put(Pattern.compile("^header\\.invoiceNumber$"), CsvMapperHeaderColumnsConfigurer.defaultColumn());
        config.put(Pattern.compile("^header\\.type$"), CsvMapperHeaderColumnsConfigurer.defaultColumn());
        config.put(Pattern.compile("^header\\.issued$"), CsvMapperHeaderColumnsConfigurer.typeColumn(Date.class, new DateProcessor()));
        config.put(Pattern.compile("^header\\.dueDate$"), CsvMapperHeaderColumnsConfigurer.typeColumn(Date.class, new DateProcessor()));
        config.put(Pattern.compile("^header\\.reference$"), CsvMapperHeaderColumnsConfigurer.defaultColumn());
        config.put(Pattern.compile("^header\\.customerNumber$"), CsvMapperHeaderColumnsConfigurer.defaultColumn());
        config.put(Pattern.compile("^header\\.currency$"), CsvMapperHeaderColumnsConfigurer.typeColumn(CurrencyCode.class));
        config.put(Pattern.compile("^header\\.note$"), CsvMapperHeaderColumnsConfigurer.defaultColumn());
        config.put(Pattern.compile("^recipient\\.name$"), CsvMapperHeaderColumnsConfigurer.defaultColumn());
        config.put(Pattern.compile("^recipient\\.contactName$"), CsvMapperHeaderColumnsConfigurer.defaultColumn());
        config.put(Pattern.compile("^recipient\\.addressLine1$"), CsvMapperHeaderColumnsConfigurer.defaultColumn());
        config.put(Pattern.compile("^recipient\\.addressLine2$"), CsvMapperHeaderColumnsConfigurer.defaultColumn());
        config.put(Pattern.compile("^recipient\\.city$"), CsvMapperHeaderColumnsConfigurer.defaultColumn());
        config.put(Pattern.compile("^recipient\\.postcode$"), CsvMapperHeaderColumnsConfigurer.defaultColumn());
        config.put(Pattern.compile("^recipient\\.countryCode$"), CsvMapperHeaderColumnsConfigurer.typeColumn(CountryCode.class));
        config.put(Pattern.compile("^recipient\\.postcode$"), CsvMapperHeaderColumnsConfigurer.defaultColumn());
        config.put(Pattern.compile("^recipient\\.email$"), CsvMapperHeaderColumnsConfigurer.defaultColumn());
        config.put(Pattern.compile("^recipient\\.taxes\\[\\d\\].number$"), CsvMapperHeaderColumnsConfigurer.defaultColumn());
        config.put(Pattern.compile("^recipient\\.taxes\\[\\d\\].type$"), CsvMapperHeaderColumnsConfigurer.typeColumn(Reference.class, new ReferenceProcessor()));
        config.put(Pattern.compile("^recipient\\.bankInfo.bankName$"), CsvMapperHeaderColumnsConfigurer.defaultColumn());
        config.put(Pattern.compile("^recipient\\.bankInfo.bic$"), CsvMapperHeaderColumnsConfigurer.defaultColumn());
        config.put(Pattern.compile("^recipient\\.bankInfo.iban$"), CsvMapperHeaderColumnsConfigurer.defaultColumn());
        config.put(Pattern.compile("^issuer\\.name$"), CsvMapperHeaderColumnsConfigurer.defaultColumn());
        config.put(Pattern.compile("^issuer\\.contactName$"), CsvMapperHeaderColumnsConfigurer.defaultColumn());
        config.put(Pattern.compile("^issuer\\.addressLine1$"), CsvMapperHeaderColumnsConfigurer.defaultColumn());
        config.put(Pattern.compile("^issuer\\.addressLine2$"), CsvMapperHeaderColumnsConfigurer.defaultColumn());
        config.put(Pattern.compile("^issuer\\.city$"), CsvMapperHeaderColumnsConfigurer.defaultColumn());
        config.put(Pattern.compile("^issuer\\.postcode$"), CsvMapperHeaderColumnsConfigurer.defaultColumn());
        config.put(Pattern.compile("^issuer\\.countryCode$"), CsvMapperHeaderColumnsConfigurer.typeColumn(CountryCode.class));
        config.put(Pattern.compile("^issuer\\.postcode$"), CsvMapperHeaderColumnsConfigurer.defaultColumn());
        config.put(Pattern.compile("^issuer\\.email$"), CsvMapperHeaderColumnsConfigurer.defaultColumn());
        config.put(Pattern.compile("^issuer\\.taxes\\[\\d\\].number$"), CsvMapperHeaderColumnsConfigurer.defaultColumn());
        config.put(Pattern.compile("^issuer\\.taxes\\[\\d\\].type$"), CsvMapperHeaderColumnsConfigurer.typeColumn(Reference.class, new ReferenceProcessor()));
        config.put(Pattern.compile("^issuer\\.bankInfo.bankName$"), CsvMapperHeaderColumnsConfigurer.defaultColumn());
        config.put(Pattern.compile("^issuer\\.bankInfo.bic$"), CsvMapperHeaderColumnsConfigurer.defaultColumn());
        config.put(Pattern.compile("^issuer\\.bankInfo.iban$"), CsvMapperHeaderColumnsConfigurer.defaultColumn());
        config.put(Pattern.compile("^items\\[\\d\\]\\.name$"), CsvMapperHeaderColumnsConfigurer.defaultColumn());
        config.put(Pattern.compile("^items\\[\\d\\]\\.quantity$"), CsvMapperHeaderColumnsConfigurer.typeColumn(BigDecimal.class));
        config.put(Pattern.compile("^items\\[\\d\\]\\.unit$"), CsvMapperHeaderColumnsConfigurer.typeColumn(UnitOfMeasurement.class, new UnitOfMeasurementProcessor()));
        config.put(Pattern.compile("^items\\[\\d\\]\\.unitPrice$"), CsvMapperHeaderColumnsConfigurer.typeColumn(BigDecimal.class));
        config.put(Pattern.compile("^items\\[\\d\\]\\.taxPercent$"), CsvMapperHeaderColumnsConfigurer.typeColumn(BigDecimal.class));
    }
}

