/*
 * Decompiled with CFR 0.152.
 */
package io.konik.csv.model;

import com.google.common.base.Objects;
import com.neovisionaries.i18n.CountryCode;
import com.neovisionaries.i18n.CurrencyCode;
import io.konik.zugferd.unece.codes.Reference;
import io.konik.zugferd.unece.codes.UnitOfMeasurement;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;

public final class Row {
    private Header header = new Header();
    private TradeParty recipient = new TradeParty();
    private TradeParty issuer = new TradeParty();
    private List<Item> items = new LinkedList<Item>();
    private String comments = "";
    private String paymentReference = "";
    private File file = new File();

    public Header getHeader() {
        return this.header;
    }

    public void setHeader(Header header) {
        this.header = header;
    }

    public TradeParty getRecipient() {
        return this.recipient;
    }

    public void setRecipient(TradeParty recipient) {
        this.recipient = recipient;
    }

    public TradeParty getIssuer() {
        return this.issuer;
    }

    public void setIssuer(TradeParty issuer) {
        this.issuer = issuer;
    }

    public List<Item> getItems() {
        return this.items;
    }

    public void setItems(List<Item> items) {
        this.items = items;
    }

    public String getComments() {
        return this.comments;
    }

    public void setComments(String comments) {
        this.comments = comments;
    }

    public String getPaymentReference() {
        return this.paymentReference;
    }

    public void setPaymentReference(String paymentReference) {
        this.paymentReference = paymentReference;
    }

    public File getFile() {
        return this.file;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Row)) {
            return false;
        }
        Row row = (Row)o;
        return Objects.equal((Object)this.header, (Object)row.header) && Objects.equal((Object)this.recipient, (Object)row.recipient) && Objects.equal((Object)this.issuer, (Object)row.issuer) && Objects.equal(this.items, row.items) && Objects.equal((Object)this.comments, (Object)row.comments) && Objects.equal((Object)this.paymentReference, (Object)row.paymentReference) && Objects.equal((Object)this.file, (Object)row.file);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.header, this.recipient, this.issuer, this.items, this.comments, this.paymentReference, this.file});
    }

    public String toString() {
        return "Row {header=" + this.header + ", recipient=" + this.recipient + ", issuer=" + this.issuer + ", items=" + this.items + ", comments='" + this.comments + '\'' + ", paymentReference='" + this.paymentReference + '\'' + ", file=" + this.file + '}';
    }

    public static class File {
        private String input = "";
        private String output = "";

        public String getInput() {
            return this.input;
        }

        public File setInput(String input) {
            this.input = input;
            return this;
        }

        public String getOutput() {
            return this.output;
        }

        public File setOutput(String output) {
            this.output = output;
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof File)) {
                return false;
            }
            File file = (File)o;
            return Objects.equal((Object)this.input, (Object)file.input) && Objects.equal((Object)this.output, (Object)file.output);
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.input, this.output});
        }

        public String toString() {
            return "File {input='" + this.input + '\'' + ", output='" + this.output + '\'' + '}';
        }
    }

    public static class BankInformation {
        private String bankName = "";
        private String bic = "";
        private String iban = "";

        public String getBankName() {
            return this.bankName;
        }

        public BankInformation setBankName(String bankName) {
            this.bankName = bankName;
            return this;
        }

        public String getBic() {
            return this.bic;
        }

        public BankInformation setBic(String bic) {
            this.bic = bic;
            return this;
        }

        public String getIban() {
            return this.iban;
        }

        public BankInformation setIban(String iban) {
            this.iban = iban;
            return this;
        }

        public String toString() {
            return "BankInformation {bankName='" + this.bankName + '\'' + ", bic='" + this.bic + '\'' + ", iban='" + this.iban + '\'' + '}';
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof BankInformation)) {
                return false;
            }
            BankInformation that = (BankInformation)o;
            return Objects.equal((Object)this.bankName, (Object)that.bankName) && Objects.equal((Object)this.bic, (Object)that.bic) && Objects.equal((Object)this.iban, (Object)that.iban);
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.bankName, this.bic, this.iban});
        }
    }

    public static class Item {
        private String name = "";
        private BigDecimal quantity = BigDecimal.ZERO;
        private UnitOfMeasurement unit = UnitOfMeasurement.UNIT;
        private BigDecimal unitPrice = BigDecimal.ZERO;
        private BigDecimal taxPercent = BigDecimal.ZERO;

        public String getName() {
            return this.name;
        }

        public Item setName(String name) {
            this.name = name;
            return this;
        }

        public BigDecimal getQuantity() {
            return this.quantity;
        }

        public Item setQuantity(BigDecimal quantity) {
            this.quantity = quantity;
            return this;
        }

        public UnitOfMeasurement getUnit() {
            return this.unit;
        }

        public Item setUnit(UnitOfMeasurement unit) {
            this.unit = unit;
            return this;
        }

        public BigDecimal getUnitPrice() {
            return this.unitPrice;
        }

        public Item setUnitPrice(BigDecimal unitPrice) {
            this.unitPrice = unitPrice;
            return this;
        }

        public BigDecimal getTaxPercent() {
            return this.taxPercent;
        }

        public Item setTaxPercent(BigDecimal taxPercent) {
            this.taxPercent = taxPercent;
            return this;
        }

        public String toString() {
            return "Item {type='" + this.name + '\'' + ", quantity=" + this.quantity + ", unit=" + (Object)((Object)this.unit) + ", unitPrice=" + this.unitPrice + ", taxPercent=" + this.taxPercent + '}';
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Item)) {
                return false;
            }
            Item item = (Item)o;
            return Objects.equal((Object)this.name, (Object)item.name) && Objects.equal((Object)this.quantity, (Object)item.quantity) && Objects.equal((Object)((Object)this.unit), (Object)((Object)item.unit)) && Objects.equal((Object)this.unitPrice, (Object)item.unitPrice) && Objects.equal((Object)this.taxPercent, (Object)item.taxPercent);
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.name, this.quantity, this.unit, this.unitPrice, this.taxPercent});
        }
    }

    public static class TradeParty {
        private String name = "";
        private String contactName = "";
        private String addressLine1 = "";
        private String addressLine2 = "";
        private String city = "";
        private String postcode = "";
        private CountryCode countryCode;
        private String email = "";
        private List<Tax> taxes = new LinkedList<Tax>();
        private BankInformation bankInfo = new BankInformation();

        public String getName() {
            return this.name;
        }

        public TradeParty setName(String name) {
            this.name = name;
            return this;
        }

        public String getContactName() {
            return this.contactName;
        }

        public TradeParty setContactName(String contactName) {
            this.contactName = contactName;
            return this;
        }

        public String getAddressLine1() {
            return this.addressLine1;
        }

        public TradeParty setAddressLine1(String addressLine1) {
            this.addressLine1 = addressLine1;
            return this;
        }

        public String getAddressLine2() {
            return this.addressLine2;
        }

        public TradeParty setAddressLine2(String addressLine2) {
            this.addressLine2 = addressLine2;
            return this;
        }

        public String getCity() {
            return this.city;
        }

        public TradeParty setCity(String city) {
            this.city = city;
            return this;
        }

        public String getPostcode() {
            return this.postcode;
        }

        public TradeParty setPostcode(String postcode) {
            this.postcode = postcode;
            return this;
        }

        public String getEmail() {
            return this.email;
        }

        public TradeParty setEmail(String email) {
            this.email = email;
            return this;
        }

        public List<Tax> getTaxes() {
            return this.taxes;
        }

        public void setTaxes(List<Tax> taxes) {
            this.taxes = taxes;
        }

        public TradeParty addTax(Tax tax) {
            this.taxes.add(tax);
            return this;
        }

        public TradeParty addTax(Tax ... tax) {
            this.taxes.addAll(Arrays.asList(tax));
            return this;
        }

        public BankInformation getBankInfo() {
            return this.bankInfo;
        }

        public TradeParty setBankInfo(BankInformation bankInfo) {
            this.bankInfo = bankInfo;
            return this;
        }

        public CountryCode getCountryCode() {
            return this.countryCode;
        }

        public TradeParty setCountryCode(CountryCode countryCode) {
            this.countryCode = countryCode;
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof TradeParty)) {
                return false;
            }
            TradeParty that = (TradeParty)o;
            return Objects.equal((Object)this.name, (Object)that.name) && Objects.equal((Object)this.contactName, (Object)that.contactName) && Objects.equal((Object)this.addressLine1, (Object)that.addressLine1) && Objects.equal((Object)this.addressLine2, (Object)that.addressLine2) && Objects.equal((Object)this.city, (Object)that.city) && Objects.equal((Object)this.postcode, (Object)that.postcode) && Objects.equal((Object)this.countryCode, (Object)that.countryCode) && Objects.equal((Object)this.email, (Object)that.email) && Objects.equal(this.taxes, that.taxes) && Objects.equal((Object)this.bankInfo, (Object)that.bankInfo);
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.name, this.contactName, this.addressLine1, this.addressLine2, this.city, this.postcode, this.countryCode, this.email, this.taxes, this.bankInfo});
        }

        public String toString() {
            return "TradeParty{name='" + this.name + '\'' + ", contactName='" + this.contactName + '\'' + ", addressLine1='" + this.addressLine1 + '\'' + ", addressLine2='" + this.addressLine2 + '\'' + ", city='" + this.city + '\'' + ", postcode='" + this.postcode + '\'' + ", countryCode=" + this.countryCode + ", email='" + this.email + '\'' + ", taxes=" + this.taxes + ", bankInfo=" + this.bankInfo + '}';
        }
    }

    public static class Tax {
        private String number = "";
        private Reference type = Reference.FC;

        public Tax() {
        }

        public Tax(String number, Reference type) {
            this.number = number;
            this.type = type;
        }

        public String getNumber() {
            return this.number;
        }

        public Tax setNumber(String number) {
            this.number = number;
            return this;
        }

        public Reference getType() {
            return this.type;
        }

        public Tax setType(Reference type) {
            this.type = type;
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Tax)) {
                return false;
            }
            Tax tax = (Tax)o;
            return Objects.equal((Object)this.number, (Object)tax.number) && Objects.equal((Object)((Object)this.type), (Object)((Object)tax.type));
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.number, this.type});
        }

        public String toString() {
            return "Tax{number='" + this.number + '\'' + ", type=" + (Object)((Object)this.type) + '}';
        }
    }

    public static final class Header {
        private String invoiceNumber = "";
        private String type = "";
        private Date issued;
        private Date dueDate;
        private String note = "";
        private String reference = "";
        private String customerNumber = "";
        private CurrencyCode currency = CurrencyCode.EUR;

        public String getInvoiceNumber() {
            return this.invoiceNumber;
        }

        public Header setInvoiceNumber(String invoiceNumber) {
            this.invoiceNumber = invoiceNumber;
            return this;
        }

        public String getType() {
            return this.type;
        }

        public Header setType(String type) {
            this.type = type;
            return this;
        }

        public Date getIssued() {
            return this.issued;
        }

        public Header setIssued(Date issued) {
            this.issued = issued;
            return this;
        }

        public Date getDueDate() {
            return this.dueDate;
        }

        public Header setDueDate(Date dueDate) {
            this.dueDate = dueDate;
            return this;
        }

        public String getNote() {
            return this.note;
        }

        public Header setNote(String note) {
            this.note = note;
            return this;
        }

        public String getReference() {
            return this.reference;
        }

        public Header setReference(String reference) {
            this.reference = reference;
            return this;
        }

        public String getCustomerNumber() {
            return this.customerNumber;
        }

        public Header setCustomerNumber(String customerNumber) {
            this.customerNumber = customerNumber;
            return this;
        }

        public CurrencyCode getCurrency() {
            return this.currency;
        }

        public Header setCurrency(CurrencyCode currency) {
            this.currency = currency;
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Header)) {
                return false;
            }
            Header header = (Header)o;
            return Objects.equal((Object)this.invoiceNumber, (Object)header.invoiceNumber) && Objects.equal((Object)this.type, (Object)header.type) && Objects.equal((Object)this.issued, (Object)header.issued) && Objects.equal((Object)this.dueDate, (Object)header.dueDate) && Objects.equal((Object)this.note, (Object)header.note) && Objects.equal((Object)this.reference, (Object)header.reference) && Objects.equal((Object)this.customerNumber, (Object)header.customerNumber) && Objects.equal((Object)this.currency, (Object)header.currency);
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.invoiceNumber, this.type, this.issued, this.dueDate, this.note, this.reference, this.customerNumber, this.currency});
        }

        public String toString() {
            return "Header{invoiceNumber='" + this.invoiceNumber + '\'' + ", type='" + this.type + '\'' + ", issued=" + this.issued + ", dueDate=" + this.dueDate + ", note='" + this.note + '\'' + ", reference='" + this.reference + '\'' + ", customerNumber='" + this.customerNumber + '\'' + ", currency=" + this.currency + '}';
        }
    }
}

