/*
 * Decompiled with CFR 0.152.
 */
package io.konik.csv.pdf;

import com.google.common.base.Function;
import io.konik.harness.FileAppender;
import java.util.Comparator;
import javax.annotation.Nullable;

public class FileAppenderPriorityComparator
implements Comparator<FileAppender> {
    private final Order order;

    public FileAppenderPriorityComparator(Order order) {
        this.order = order;
    }

    @Override
    public int compare(FileAppender fa1, FileAppender fa2) {
        if (fa1 != null && fa2 != null) {
            return this.order.apply(fa1.getPriority() - fa2.getPriority());
        }
        if (fa1 != null) {
            return this.order.apply(1);
        }
        return 0;
    }

    public static enum Order {
        DESC(new Function<Integer, Integer>(){

            public Integer apply(Integer input) {
                return input * -1;
            }
        }),
        ASC(new Function<Integer, Integer>(){

            public Integer apply(@Nullable Integer input) {
                return input;
            }
        });

        private Function<Integer, Integer> transform;

        private Order(Function<Integer, Integer> transform) {
            this.transform = transform;
        }

        public Integer apply(Integer value) {
            return (Integer)this.transform.apply((Object)value);
        }
    }
}

