/*
 * Decompiled with CFR 0.152.
 */
package io.konik.jaxb.adapter;

import com.neovisionaries.i18n.CountryCode;
import io.konik.jaxb.bindable.entity.TradeCountry;
import io.konik.util.Strings;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.annotation.adapters.XmlAdapter;

public class CountryAdapter
extends XmlAdapter<TradeCountry, CountryCode> {
    private static final Logger LOG = Logger.getLogger(CountryAdapter.class.getName());

    public TradeCountry marshal(CountryCode country) throws Exception {
        if (country == null) {
            return null;
        }
        return new TradeCountry(country.getAlpha2());
    }

    public CountryCode unmarshal(TradeCountry tradeCountry) throws Exception {
        if (tradeCountry == null) {
            return null;
        }
        if (Strings.isNullOrEmpty(tradeCountry.getCode())) {
            LOG.log(Level.WARNING, "Trade Country is defined in XML but the code is empty or null");
            return null;
        }
        return CountryCode.getByCode((String)tradeCountry.getCode());
    }
}

