/*
 * Decompiled with CFR 0.152.
 */
package io.konik.jaxb.adapter;

import io.konik.util.Strings;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.xml.bind.annotation.adapters.XmlAdapter;

public class IssueDateTimeAdapter
extends XmlAdapter<String, Date> {
    private final ThreadLocal<SimpleDateFormat> dateTimeFormatter = new ThreadLocal<SimpleDateFormat>(){

        @Override
        protected SimpleDateFormat initialValue() {
            return new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
        }
    };

    public Date unmarshal(String date) throws Exception {
        if (Strings.isNullOrEmpty(date)) {
            return null;
        }
        return this.dateTimeFormatter.get().parse(date.trim());
    }

    public String marshal(Date date) throws Exception {
        if (date == null) {
            return null;
        }
        return this.dateTimeFormatter.get().format(date);
    }
}

