/*
 * Decompiled with CFR 0.152.
 */
package io.konik.jaxb.adapter;

import io.konik.zugferd.entity.Parameter;
import io.konik.zugferd.profile.ConformanceLevel;
import io.konik.zugferd.profile.Profile;
import io.konik.zugferd.profile.ProfileVersion;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.annotation.adapters.XmlAdapter;

public class ParameterProfileAdapter
extends XmlAdapter<Parameter, Profile> {
    private static final Logger LOG = Logger.getLogger(ParameterProfileAdapter.class.getName());
    private static final String DELIMITER = ":";

    public Profile unmarshal(Parameter p) throws Exception {
        if (p == null) {
            return null;
        }
        String fullName = p.getId();
        try {
            ProfileVersion version = ProfileVersion.extractVersion(fullName);
            ConformanceLevel conformanceLevel = ConformanceLevel.extractConformanceLevel(fullName);
            String ns = ParameterProfileAdapter.getNamespace(fullName);
            return new Profile(ns, version, conformanceLevel);
        }
        catch (RuntimeException e) {
            LOG.log(Level.WARNING, "Could not parse the profile. Fallback to BASIC latest version", e);
            return new Profile(ConformanceLevel.BASIC);
        }
    }

    private static String getNamespace(String fullName) {
        String[] tokens = fullName.split(DELIMITER);
        StringBuilder ns = new StringBuilder();
        for (int i = 0; i < tokens.length - 2; ++i) {
            ns.append(tokens[i]).append(DELIMITER);
        }
        return ns.toString();
    }

    public Parameter marshal(Profile profile) throws Exception {
        if (profile == null) {
            return null;
        }
        return new Parameter(profile.fullName());
    }
}

