/*
 * Decompiled with CFR 0.152.
 */
package io.konik.jaxb.adapter;

import io.konik.Configuration;
import java.math.BigDecimal;
import java.math.RoundingMode;
import javax.xml.bind.annotation.adapters.XmlAdapter;

public class QuantityRoundingAdapter
extends XmlAdapter<BigDecimal, BigDecimal> {
    private static final String DEFAULT_ROUNDING_MODE = "HALF_UP";
    private static final String DEFAULT_SCALE = "4";
    final int scale;
    final RoundingMode roundingMode;
    private final boolean stripTrailingZeros;

    public QuantityRoundingAdapter() {
        String name = ((Object)((Object)this)).getClass().getName();
        this.scale = Integer.parseInt(Configuration.INSTANCE.getProperty(name + ".scale", DEFAULT_SCALE));
        this.roundingMode = RoundingMode.valueOf(Configuration.INSTANCE.getProperty(name + ".roundingMode", DEFAULT_ROUNDING_MODE));
        this.stripTrailingZeros = Configuration.INSTANCE.stripTrailingZeros();
    }

    public BigDecimal unmarshal(BigDecimal amount) throws Exception {
        return amount;
    }

    public BigDecimal marshal(BigDecimal amount) throws Exception {
        if (amount == null) {
            return null;
        }
        BigDecimal roundedValue = amount.setScale(this.scale, this.roundingMode);
        if (this.stripTrailingZeros) {
            return roundedValue.stripTrailingZeros();
        }
        return roundedValue;
    }
}

