/*
 * Decompiled with CFR 0.152.
 */
package io.konik.jaxb.adapter;

import io.konik.Configuration;
import io.konik.zugferd.unqualified.Amount;
import java.math.BigDecimal;
import java.math.RoundingMode;
import javax.xml.bind.annotation.adapters.XmlAdapter;

public class TwoDigitRoundingAdapter
extends XmlAdapter<Amount, Amount> {
    private static final String DEFAULT_SCALE = "2";
    private static final String DEFAULT_ROUNDING_MODE = "HALF_UP";
    private final int scale;
    private final RoundingMode roundingMode;
    private boolean stripTrailingZeros;

    public TwoDigitRoundingAdapter() {
        String name = ((Object)((Object)this)).getClass().getName();
        this.scale = Integer.parseInt(Configuration.INSTANCE.getProperty(name + ".scale", this.getDefaultScale()));
        this.roundingMode = RoundingMode.valueOf(Configuration.INSTANCE.getProperty(name + ".roundingMode", DEFAULT_ROUNDING_MODE));
        this.stripTrailingZeros = Configuration.INSTANCE.stripTrailingZeros();
    }

    protected String getDefaultScale() {
        return DEFAULT_SCALE;
    }

    public Amount unmarshal(Amount amount) throws Exception {
        return amount;
    }

    public Amount marshal(Amount amount) throws Exception {
        if (amount == null || amount.getValue() == null) {
            return amount;
        }
        return amount.setValue(this.round(amount));
    }

    private BigDecimal round(Amount amount) {
        BigDecimal rounded = amount.getValue().setScale(this.scale, this.roundingMode);
        if (this.stripTrailingZeros) {
            return rounded.stripTrailingZeros();
        }
        return rounded;
    }
}

