/*
 * Decompiled with CFR 0.152.
 */
package io.konik.jaxb.bindable.entity;

import io.konik.jaxb.bindable.entity.UniversalCommunication;
import io.konik.util.Strings;
import java.util.regex.Pattern;
import javax.xml.bind.annotation.adapters.XmlAdapter;

public class UniversalCommunicationAdapter
extends XmlAdapter<UniversalCommunication, String> {
    Pattern emailRegEx = Pattern.compile(".+@.+\\..+");

    public UniversalCommunication marshal(String unversalCommunication) throws Exception {
        if (Strings.isNullOrEmpty(unversalCommunication)) {
            return null;
        }
        UniversalCommunication communication = new UniversalCommunication();
        if (this.emailRegEx.matcher(unversalCommunication).matches()) {
            communication.setMail(unversalCommunication);
        } else {
            communication.setCompleteNumber(unversalCommunication);
        }
        return communication;
    }

    public String unmarshal(UniversalCommunication communication) throws Exception {
        if (Strings.isNotEmpty(communication.getCompleteNumber())) {
            return communication.getCompleteNumber();
        }
        return communication.getMail();
    }
}

