/*
 * Decompiled with CFR 0.152.
 */
package io.konik.sdk;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import io.konik.Configuration;
import io.konik.zugferd.unqualified.ZfDate;
import io.konik.zugferd.unqualified.ZfDateDay;
import java.io.IOException;

public class ZinvoiceApiConfig {
    private final String apiKey;
    private final String destinationUrl;

    public ZinvoiceApiConfig() {
        this(Configuration.INSTANCE.getProperty("io.konik.zinvoice.api-key"), Configuration.INSTANCE.getProperty("io.konik.zinvoice.url"));
    }

    public ZinvoiceApiConfig(String apiKey, String destinationUrl) {
        this.apiKey = apiKey;
        this.destinationUrl = destinationUrl;
    }

    public String getApiKey() {
        return this.apiKey;
    }

    public String getDestinationUrl() {
        return this.destinationUrl;
    }

    public ObjectMapper getDefaulObjectMapper() {
        SimpleModule module = new SimpleModule();
        module.addDeserializer(ZfDate.class, (JsonDeserializer)new JsonDeserializer<ZfDate>(){

            public ZfDate deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
                Long timestamp = (Long)jp.readValueAs(Long.class);
                return new ZfDateDay(timestamp);
            }
        });
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        objectMapper.registerModule((Module)module);
        return objectMapper;
    }
}

