/*
 * Decompiled with CFR 0.152.
 */
package io.konik.sdk.http;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpContent;
import com.google.api.client.http.HttpHeaders;
import com.google.api.client.http.HttpMediaType;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestFactory;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpResponseException;
import com.google.api.client.http.InputStreamContent;
import com.google.api.client.http.MultipartContent;
import com.google.api.client.http.javanet.NetHttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.JsonObjectParser;
import com.google.api.client.json.jackson2.JacksonFactory;
import com.google.api.client.util.ObjectParser;
import com.google.common.io.ByteStreams;
import io.konik.sdk.ZinvoiceApiConfig;
import io.konik.sdk.http.BadRequestException;
import io.konik.sdk.http.ErrorResponse;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import org.apache.tika.detect.DefaultDetector;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.mime.MediaType;

public class ZinvoiceHttpClient {
    public static final HttpRequestFactory DEFAULT_HTTP_REQUEST_FACTORY = new NetHttpTransport().createRequestFactory(new HttpRequestInitializer(){

        public void initialize(HttpRequest httpRequest) throws IOException {
            httpRequest.setParser((ObjectParser)new JsonObjectParser((JsonFactory)new JacksonFactory()));
        }
    });
    private final ZinvoiceApiConfig apiConfig;
    private final HttpRequestFactory httpRequestFactory;
    private final ObjectMapper objectMapper;

    public ZinvoiceHttpClient(ZinvoiceApiConfig apiConfig, HttpRequestFactory httpRequestFactory, ObjectMapper objectMapper) {
        this.apiConfig = apiConfig;
        this.httpRequestFactory = httpRequestFactory;
        this.objectMapper = objectMapper;
    }

    public ZinvoiceHttpClient(ZinvoiceApiConfig apiConfig, ObjectMapper objectMapper) {
        this.apiConfig = apiConfig;
        this.objectMapper = objectMapper;
        this.httpRequestFactory = DEFAULT_HTTP_REQUEST_FACTORY;
    }

    public ZinvoiceHttpClient(ZinvoiceApiConfig apiConfig) {
        this.apiConfig = apiConfig;
        this.objectMapper = apiConfig.getDefaulObjectMapper();
        this.httpRequestFactory = DEFAULT_HTTP_REQUEST_FACTORY;
    }

    public <T> T get(String endpoint, Class<T> responseTypeClass) {
        Object result;
        try {
            HttpRequest request = this.httpRequestFactory.buildGetRequest(this.createEndpoint(endpoint));
            request.setHeaders(new HttpHeaders().set("API-KEY", (Object)this.apiConfig.getApiKey()));
            HttpResponse response = request.execute();
            result = this.objectMapper.readValue(response.parseAsString(), responseTypeClass);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return (T)result;
    }

    public InputStream download(String endpoint) {
        try {
            HttpRequest request = this.httpRequestFactory.buildGetRequest(this.createEndpoint(endpoint));
            request.setHeaders(new HttpHeaders().set("API-KEY", (Object)this.apiConfig.getApiKey()).setAccept("application/json"));
            return request.execute().getContent();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public <T> T upload(String endpoint, Map<String, InputStream> files, Class<T> responseTypeClass) {
        try {
            MultipartContent content = new MultipartContent();
            content.setMediaType(new HttpMediaType("multipart/form-data").setParameter("boundary", "__END_OF_PART__"));
            DefaultDetector detector = new DefaultDetector();
            for (String key : files.keySet()) {
                ByteArrayInputStream file = new ByteArrayInputStream(ByteStreams.toByteArray((InputStream)files.get(key)));
                MediaType mediaType = detector.detect((InputStream)file, new Metadata());
                MultipartContent.Part part = new MultipartContent.Part((HttpContent)new InputStreamContent(mediaType.toString(), (InputStream)file));
                part.setHeaders(new HttpHeaders().set("Content-Disposition", (Object)String.format("form-data; name=\"%s\"; filename=\"%s\"", key, key)));
                content.addPart(part);
            }
            HttpRequest request = this.httpRequestFactory.buildPostRequest(this.createEndpoint(endpoint), (HttpContent)content);
            request.setHeaders(new HttpHeaders().set("API-KEY", (Object)this.apiConfig.getApiKey()).setAccept("application/json"));
            HttpResponse response = request.execute();
            return (T)this.objectMapper.readValue(response.parseAsString(), responseTypeClass);
        }
        catch (HttpResponseException e) {
            if (e.getStatusCode() == 400) {
                throw new BadRequestException(this.getErrorResponse(e));
            }
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public <T> T post(String endpoint, byte[] body, String contentType, Class<T> responseTypeClass) {
        Object result;
        try {
            InputStreamContent content = new InputStreamContent(contentType, (InputStream)new ByteArrayInputStream(body));
            HttpRequest request = this.httpRequestFactory.buildPostRequest(this.createEndpoint(endpoint), (HttpContent)content);
            request.setHeaders(new HttpHeaders().set("API-KEY", (Object)this.apiConfig.getApiKey()));
            HttpResponse response = request.execute();
            result = this.objectMapper.readValue(response.parseAsString(), responseTypeClass);
        }
        catch (HttpResponseException e) {
            if (e.getStatusCode() == 400) {
                throw new BadRequestException(this.getErrorResponse(e));
            }
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return (T)result;
    }

    public <T> T put(String endpoint, byte[] body, String contentType, Class<T> responseTypeClass) {
        Object result;
        try {
            InputStreamContent content = new InputStreamContent(contentType, (InputStream)new ByteArrayInputStream(body));
            HttpRequest request = this.httpRequestFactory.buildPutRequest(this.createEndpoint(endpoint), (HttpContent)content);
            request.setHeaders(new HttpHeaders().set("API-KEY", (Object)this.apiConfig.getApiKey()));
            HttpResponse response = request.execute();
            result = this.objectMapper.readValue(response.parseAsString(), responseTypeClass);
        }
        catch (HttpResponseException e) {
            if (e.getStatusCode() == 400) {
                throw new BadRequestException(this.getErrorResponse(e));
            }
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return (T)result;
    }

    public void delete(String endpoint) {
        try {
            HttpRequest request = this.httpRequestFactory.buildDeleteRequest(this.createEndpoint(endpoint));
            request.setHeaders(new HttpHeaders().set("API-KEY", (Object)this.apiConfig.getApiKey()));
            request.execute();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private ErrorResponse getErrorResponse(HttpResponseException e) {
        ErrorResponse errorResponse;
        try {
            errorResponse = (ErrorResponse)this.objectMapper.readValue(e.getContent(), ErrorResponse.class);
        }
        catch (IOException e1) {
            throw new RuntimeException(e1);
        }
        return errorResponse;
    }

    private GenericUrl createEndpoint(String endpoint) {
        return new GenericUrl(this.apiConfig.getDestinationUrl() + endpoint);
    }
}

