/*
 * Decompiled with CFR 0.152.
 */
package io.konik.sdk.invoice;

import com.google.api.client.http.HttpResponseException;
import com.google.api.client.util.Maps;
import io.konik.InvoiceTransformer;
import io.konik.sdk.http.InsufficientCreditsAmountException;
import io.konik.sdk.http.ZinvoiceHttpClient;
import io.konik.sdk.invoice.InvoiceApi;
import io.konik.sdk.invoice.InvoiceDocument;
import io.konik.sdk.invoice.InvoiceResponse;
import io.konik.sdk.invoice.Status;
import io.konik.sdk.invoice.StatusResponse;
import io.konik.zugferd.Invoice;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestInvoiceApi
implements InvoiceApi {
    private static final Logger log = LoggerFactory.getLogger(RestInvoiceApi.class);
    private final ZinvoiceHttpClient httpClient;
    private final InvoiceTransformer invoiceTransformer;

    public RestInvoiceApi(ZinvoiceHttpClient zinvoiceHttpClient) {
        this.httpClient = zinvoiceHttpClient;
        this.invoiceTransformer = new InvoiceTransformer();
    }

    public RestInvoiceApi(ZinvoiceHttpClient zinvoiceHttpClient, InvoiceTransformer invoiceTransformer) {
        this.httpClient = zinvoiceHttpClient;
        this.invoiceTransformer = invoiceTransformer;
    }

    @Override
    public InvoiceDocument getInvoice(String id) {
        InvoiceDocument.Response response = this.httpClient.get("/invoice/" + id, InvoiceDocument.Response.class);
        if (response != null) {
            return response.getDocument();
        }
        return null;
    }

    @Override
    public InvoiceResponse createInvoice(Invoice invoice) {
        byte[] invoiceXml = this.invoiceTransformer.fromModel(invoice);
        return this.httpClient.post("/invoice", invoiceXml, "application/xml", InvoiceResponse.class);
    }

    @Override
    public InvoiceResponse createDraftInvoice(Invoice invoice) {
        byte[] invoiceXml = this.invoiceTransformer.fromModel(invoice);
        return this.httpClient.post("/invoice/draft", invoiceXml, "application/xml", InvoiceResponse.class);
    }

    @Override
    public InvoiceResponse updateInvoice(String invoiceId, Invoice invoice) {
        byte[] invoiceXml = this.invoiceTransformer.fromModel(invoice);
        return this.httpClient.put("/invoice/" + invoiceId, invoiceXml, "application/xml", InvoiceResponse.class);
    }

    @Override
    public InvoiceResponse updateDraftInvoice(String invoiceId, Invoice invoice) {
        byte[] invoiceXml = this.invoiceTransformer.fromModel(invoice);
        return this.httpClient.put("/invoice/draft/" + invoiceId, invoiceXml, "application/xml", InvoiceResponse.class);
    }

    @Override
    public InputStream downloadInvoiceAsPDF(String invoiceId) {
        try {
            return this.httpClient.download("/invoice/" + invoiceId + "/pdf");
        }
        catch (RuntimeException e) {
            HttpResponseException responseException;
            if (e.getCause() instanceof HttpResponseException && (responseException = (HttpResponseException)e.getCause()).getStatusCode() == 409) {
                throw new InsufficientCreditsAmountException();
            }
            throw e;
        }
    }

    @Override
    public void deleteInvoice(String invoiceId) {
        this.httpClient.delete("/invoice/" + invoiceId);
    }

    @Override
    public boolean sendInvoice(String invoiceId, String email, String message) {
        try {
            String encodedMessage = URLEncoder.encode(message, "UTF-8");
            String json = "{\"recipient\":\"" + email + "\", \"message\":\"" + encodedMessage + "\"}";
            InvoiceResponse createdInvoice = this.httpClient.post("/invoice/" + invoiceId + "/pdf/send", json.getBytes(Charset.forName("UTF-8")), "application/json", InvoiceResponse.class);
            return createdInvoice != null && createdInvoice.getInvoiceId() != null;
        }
        catch (RuntimeException e) {
            HttpResponseException responseException;
            if (e.getCause() instanceof HttpResponseException && (responseException = (HttpResponseException)e.getCause()).getStatusCode() == 409) {
                throw new InsufficientCreditsAmountException();
            }
            throw e;
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean sendInvoice(String invoiceId, String email) {
        return this.sendInvoice(invoiceId, email, "");
    }

    @Override
    public InvoiceResponse uploadInvoice(InputStream pdf, InvoiceDocument.Type type) {
        HashMap files = Maps.newHashMap();
        files.put("pdf", pdf);
        return this.httpClient.upload(String.format("/invoice/pdf?type=%s", type.toString()), files, InvoiceResponse.class);
    }

    @Override
    public StatusResponse updateStatus(String invoiceId, Status status) {
        try {
            String json = String.format("{\"status\": \"%s\"}", status.toString());
            String url = String.format("/invoice/%s/status", invoiceId);
            log.debug("Updating status of the invoice with id {}: {}", (Object)invoiceId, (Object)json);
            StatusResponse response = this.httpClient.post(url, json.getBytes("UTF-8"), "application/json", StatusResponse.class);
            log.debug("Change status response = {}", (Object)response);
            return response;
        }
        catch (Exception e) {
            log.warn("Caught exception {}: {}", (Object)e.getClass().getSimpleName(), (Object)e.getMessage());
            throw new RuntimeException(e);
        }
    }
}

