/*
 * Decompiled with CFR 0.152.
 */
package io.konik.sdk.json;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import java.io.IOException;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class DateDeserializer
extends JsonDeserializer<Date> {
    private static final DateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd");

    public Date deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
        String dateAsString = (String)jsonParser.readValueAs(String.class);
        Date date = null;
        try {
            date = DATE_FORMAT.parse(dateAsString);
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
        return date;
    }
}

