/*
 * Decompiled with CFR 0.152.
 */
package io.konik.util;

import com.neovisionaries.i18n.CurrencyCode;
import io.konik.zugferd.unqualified.Amount;
import java.math.BigDecimal;
import java.math.RoundingMode;

public final class Amounts {
    public static Amount zero(CurrencyCode currencyCode) {
        return new Amount(BigDecimal.ZERO, currencyCode);
    }

    public static Amount add(Amount first, Amount second) {
        if (first == null && second == null) {
            throw new IllegalArgumentException("First and second amount cannot be null");
        }
        if (first != null && second != null && !first.getCurrency().equals((Object)second.getCurrency())) {
            throw new IllegalArgumentException("Cannot add two amounts with different currencies");
        }
        CurrencyCode currency = first != null ? first.getCurrency() : second.getCurrency();
        BigDecimal firstValue = first != null ? first.getValue() : BigDecimal.ZERO;
        BigDecimal secondValue = second != null ? second.getValue() : BigDecimal.ZERO;
        return new Amount(firstValue.add(secondValue), currency);
    }

    public static Amount multiply(Amount amount, BigDecimal times) {
        return new Amount(amount.getValue().multiply(times), amount.getCurrency());
    }

    public static Amount divide(Amount amount, BigDecimal devisor) {
        return new Amount(amount.getValue().divide(devisor, 4, RoundingMode.HALF_UP), amount.getCurrency());
    }

    public static Amount negate(Amount amount) {
        return new Amount(amount.getValue().negate(), amount.getCurrency());
    }

    public static Amount abs(Amount amount) {
        return new Amount(amount.getValue().abs(), amount.getCurrency());
    }

    public static Amount setPrecision(Amount amount, int precision, RoundingMode roundingMode) {
        if (amount == null) {
            return null;
        }
        return new Amount(amount.getValue().setScale(precision, roundingMode), amount.getCurrency());
    }

    public static Amount copy(Amount amount) {
        if (amount == null) {
            return null;
        }
        return new Amount(amount.getValue(), amount.getCurrency());
    }
}

