/*
 * Decompiled with CFR 0.152.
 */
package io.konik.util;

import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import io.konik.zugferd.entity.GrossPrice;
import io.konik.zugferd.entity.trade.item.Item;
import java.math.BigDecimal;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nullable;

public final class Items {
    public static List<Item> filter(List<Item> items, Predicate<Item> predicate) {
        return new LinkedList<Item>(Collections2.filter(items, predicate));
    }

    public static List<Item> purchasableItemsOnly(List<Item> items) {
        return Items.filter(items, new Predicate<Item>(){

            public boolean apply(@Nullable Item item) {
                return item != null && item.getDelivery() != null && item.getAgreement() != null && item.getSettlement() != null;
            }
        });
    }

    public static BigDecimal basisQuantity(Item item) {
        GrossPrice grossPrice = item.getAgreement().getGrossPrice();
        if (grossPrice == null || grossPrice.getBasis() == null) {
            return BigDecimal.ONE;
        }
        return grossPrice.getBasis().getValue();
    }
}

