/*
 * Decompiled with CFR 0.152.
 */
package io.konik.util;

import com.neovisionaries.i18n.CurrencyCode;
import io.konik.util.Amounts;
import io.konik.zugferd.entity.trade.MonetarySummation;
import io.konik.zugferd.entity.trade.item.SpecifiedMonetarySummation;
import io.konik.zugferd.unqualified.Amount;
import java.math.RoundingMode;

public final class MonetarySummations {
    public static MonetarySummation newMonetarySummation(CurrencyCode currencyCode) {
        Amount zeroAmount = Amounts.zero(currencyCode);
        MonetarySummation monetarySummation = new MonetarySummation();
        monetarySummation.setAllowanceTotal(zeroAmount);
        monetarySummation.setChargeTotal(zeroAmount);
        monetarySummation.setDuePayable(zeroAmount);
        monetarySummation.setGrandTotal(zeroAmount);
        monetarySummation.setLineTotal(zeroAmount);
        monetarySummation.setTaxBasisTotal(zeroAmount);
        monetarySummation.setTaxTotal(zeroAmount);
        monetarySummation.setTotalPrepaid(zeroAmount);
        return monetarySummation;
    }

    public static SpecifiedMonetarySummation newSpecifiedMonetarySummation(CurrencyCode currencyCode) {
        Amount zeroAmount = Amounts.zero(currencyCode);
        SpecifiedMonetarySummation monetarySummation = new SpecifiedMonetarySummation();
        monetarySummation.setLineTotal(zeroAmount);
        monetarySummation.setTotalAllowanceCharge(zeroAmount);
        return monetarySummation;
    }

    public static MonetarySummation newMonetarySummation(MonetarySummation monetarySummation) {
        MonetarySummation copy = new MonetarySummation();
        copy.setChargeTotal(Amounts.copy(monetarySummation.getChargeTotal()));
        copy.setDuePayable(Amounts.copy(monetarySummation.getDuePayable()));
        copy.setLineTotal(Amounts.copy(monetarySummation.getLineTotal()));
        copy.setTotalPrepaid(Amounts.copy(monetarySummation.getTotalPrepaid()));
        copy.setGrandTotal(Amounts.copy(monetarySummation.getGrandTotal()));
        copy.setAllowanceTotal(Amounts.copy(monetarySummation.getAllowanceTotal()));
        copy.setTaxBasisTotal(Amounts.copy(monetarySummation.getTaxBasisTotal()));
        copy.setTaxTotal(Amounts.copy(monetarySummation.getTaxTotal()));
        return copy;
    }

    public static MonetarySummation precise(MonetarySummation monetarySummation, int precision, RoundingMode roundingMode) {
        MonetarySummation copy = MonetarySummations.newMonetarySummation(monetarySummation);
        copy.setChargeTotal(Amounts.setPrecision(copy.getChargeTotal(), precision, roundingMode));
        copy.setDuePayable(Amounts.setPrecision(copy.getDuePayable(), precision, roundingMode));
        copy.setLineTotal(Amounts.setPrecision(copy.getLineTotal(), precision, roundingMode));
        copy.setTotalPrepaid(Amounts.setPrecision(copy.getTotalPrepaid(), precision, roundingMode));
        copy.setGrandTotal(Amounts.setPrecision(copy.getGrandTotal(), precision, roundingMode));
        copy.setAllowanceTotal(Amounts.setPrecision(copy.getAllowanceTotal(), precision, roundingMode));
        copy.setTaxBasisTotal(Amounts.setPrecision(copy.getTaxBasisTotal(), precision, roundingMode));
        copy.setTaxTotal(Amounts.setPrecision(copy.getTaxTotal(), precision, roundingMode));
        return copy;
    }
}

