/*
 * Decompiled with CFR 0.152.
 */
package io.konik.validation;

import io.konik.validation.MonetarySummationValidator;
import io.konik.validator.annotation.Comfort;
import io.konik.validator.annotation.Extended;
import io.konik.zugferd.Invoice;
import io.konik.zugferd.profile.ConformanceLevel;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.validation.ConstraintViolation;
import javax.validation.MessageInterpolator;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import javax.validation.groups.Default;
import org.apache.bval.jsr.DefaultMessageInterpolator;

@Named
@Singleton
public class InvoiceValidator {
    private final Validator validator;
    private final MonetarySummationValidator monetarySummationValidator;

    @Inject
    public InvoiceValidator(Validator validator, MonetarySummationValidator monetarySummationValidator) {
        this.validator = validator;
        this.monetarySummationValidator = monetarySummationValidator;
    }

    public InvoiceValidator(Validator validator) {
        this.validator = validator;
        this.monetarySummationValidator = new MonetarySummationValidator((MessageInterpolator)new DefaultMessageInterpolator());
    }

    public InvoiceValidator() {
        ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
        this.validator = factory.getValidator();
        this.monetarySummationValidator = new MonetarySummationValidator((MessageInterpolator)new DefaultMessageInterpolator());
    }

    public Set<ConstraintViolation<Invoice>> validate(Invoice invoice) {
        ConformanceLevel conformanceLevel = invoice.getContext().getGuideline().getConformanceLevel();
        Class[] validationGroups = InvoiceValidator.resolveIntoValidationGroups(conformanceLevel);
        Set violations = this.validator.validate((Object)invoice, validationGroups);
        if (this.monetarySummationValidator != null) {
            violations.addAll(this.monetarySummationValidator.validate(invoice, validationGroups));
        }
        return violations;
    }

    public static Class<?>[] resolveIntoValidationGroups(ConformanceLevel conformanceLevel) {
        switch (conformanceLevel) {
            case BASIC: {
                return new Class[]{Default.class};
            }
            case COMFORT: {
                return new Class[]{Default.class, Comfort.class};
            }
            case EXTENDED: {
                return new Class[]{Default.class, Comfort.class, Extended.class};
            }
        }
        throw new IllegalArgumentException("Provided Profile:" + (Object)((Object)conformanceLevel) + "not covered");
    }
}

