/*
 * Decompiled with CFR 0.152.
 */
package io.konik.validation;

import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.Iterables;
import io.konik.validation.AmountCalculator;
import io.konik.validator.annotation.Basic;
import io.konik.zugferd.Invoice;
import io.konik.zugferd.entity.GrossPrice;
import io.konik.zugferd.entity.PaymentMeans;
import io.konik.zugferd.entity.trade.MonetarySummation;
import io.konik.zugferd.entity.trade.Settlement;
import io.konik.zugferd.entity.trade.Trade;
import io.konik.zugferd.entity.trade.item.Item;
import io.konik.zugferd.entity.trade.item.SpecifiedMonetarySummation;
import io.konik.zugferd.entity.trade.item.SpecifiedSettlement;
import io.konik.zugferd.profile.ConformanceLevel;
import io.konik.zugferd.unqualified.Amount;
import java.lang.annotation.Annotation;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import javax.validation.ConstraintTarget;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintViolation;
import javax.validation.MessageInterpolator;
import javax.validation.Path;
import javax.validation.Payload;
import javax.validation.metadata.ConstraintDescriptor;
import org.apache.bval.jsr.util.PathImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MonetarySummationValidator {
    private static Logger log = LoggerFactory.getLogger(MonetarySummationValidator.class);
    private final MessageInterpolator messageInterpolator;

    public MonetarySummationValidator(MessageInterpolator messageInterpolator) {
        this.messageInterpolator = messageInterpolator;
    }

    public static boolean belongsToProfile(Class<?> clazz, String methodName, final List<Class<?>> validationGroups) {
        try {
            Annotation[] annotations = clazz.getMethod(methodName, new Class[0]).getAnnotations();
            LinkedList profileAnnotationsOnly = new LinkedList(Collections2.filter(Arrays.asList(annotations), (Predicate)new Predicate<Annotation>(){

                public boolean apply(Annotation annotation) {
                    return ConformanceLevel.getAnnotations().contains(annotation.annotationType());
                }
            }));
            if (profileAnnotationsOnly.isEmpty()) {
                return true;
            }
            if (profileAnnotationsOnly.size() == 1 && ((Annotation)profileAnnotationsOnly.get(0)).annotationType().equals(Basic.class)) {
                return true;
            }
            return Iterables.any(profileAnnotationsOnly, (Predicate)new Predicate<Annotation>(){

                public boolean apply(@Nullable Annotation annotation) {
                    return validationGroups.contains(annotation.annotationType());
                }
            });
        }
        catch (Exception e) {
            log.warn("{} caught while checking if method {} from class {} belongs to validation groups: {}", new Object[]{e.getClass().getSimpleName(), methodName, clazz, e.getMessage()});
            return false;
        }
    }

    public Set<ConstraintViolation<Invoice>> validate(Invoice invoice, Class<?>[] validationGroups) {
        if (invoice == null) {
            throw new IllegalArgumentException("Invoice cannot be null");
        }
        HashSet<ConstraintViolation<Invoice>> violations = new HashSet<ConstraintViolation<Invoice>>();
        Trade trade = invoice.getTrade();
        if (trade != null) {
            Settlement settlement = trade.getSettlement();
            List<Class<?>> validationGroupsList = Arrays.asList(validationGroups);
            if (settlement.getMonetarySummation() != null) {
                String message;
                boolean expectDuePayable;
                String message2;
                log.debug("Validating invoice monetary summation...");
                MonetarySummation monetarySummation = settlement.getMonetarySummation();
                MonetarySummation calculatedMonetarySummation = AmountCalculator.recalculate(invoice).getMonetarySummation();
                Class<MonetarySummation> clazz = MonetarySummation.class;
                if (MonetarySummationValidator.belongsToProfile(clazz, "getGrandTotal", validationGroupsList) && !MonetarySummationValidator.areEqual(monetarySummation.getGrandTotal(), calculatedMonetarySummation.getGrandTotal())) {
                    message2 = this.message(monetarySummation.getGrandTotal(), calculatedMonetarySummation.getGrandTotal());
                    violations.add(new Violation(invoice, message2, "monetarySummation.grandTotal.error", "trade.settlement.monetarySummation.grandTotal", monetarySummation.getGrandTotal() != null ? monetarySummation.getGrandTotal().getValue() : null));
                }
                if (MonetarySummationValidator.belongsToProfile(clazz, "getTaxBasisTotal", validationGroupsList) && !MonetarySummationValidator.areEqual(monetarySummation.getTaxBasisTotal(), calculatedMonetarySummation.getTaxBasisTotal())) {
                    message2 = this.message(monetarySummation.getTaxBasisTotal(), calculatedMonetarySummation.getTaxBasisTotal());
                    violations.add(new Violation(invoice, message2, "monetarySummation.taxBasisTotal.error", "trade.settlement.monetarySummation.taxBasisTotal", monetarySummation.getTaxBasisTotal() != null ? monetarySummation.getTaxBasisTotal().getValue() : null));
                }
                if (MonetarySummationValidator.belongsToProfile(clazz, "getChargeTotal", validationGroupsList) && !MonetarySummationValidator.areEqual(monetarySummation.getChargeTotal(), calculatedMonetarySummation.getChargeTotal())) {
                    message2 = this.message(monetarySummation.getChargeTotal(), calculatedMonetarySummation.getChargeTotal());
                    violations.add(new Violation(invoice, message2, "monetarySummation.chargeTotal.error", "trade.settlement.monetarySummation.chargeTotal", monetarySummation.getChargeTotal() != null ? monetarySummation.getChargeTotal().getValue() : null));
                }
                if (MonetarySummationValidator.belongsToProfile(clazz, "getAllowanceTotal", validationGroupsList) && !MonetarySummationValidator.areEqual(monetarySummation.getAllowanceTotal(), calculatedMonetarySummation.getAllowanceTotal())) {
                    message2 = this.message(monetarySummation.getAllowanceTotal(), calculatedMonetarySummation.getAllowanceTotal());
                    violations.add(new Violation(invoice, message2, "monetarySummation.allowanceTotal.error", "trade.settlement.monetarySummation.allowanceTotal", monetarySummation.getAllowanceTotal() != null ? monetarySummation.getAllowanceTotal().getValue() : null));
                }
                boolean bl = expectDuePayable = monetarySummation.getTotalPrepaid() != null && !MonetarySummationValidator.isEqualZero(monetarySummation.getTotalPrepaid());
                if (settlement.getPaymentMeans() != null) {
                    for (PaymentMeans paymentMeans : settlement.getPaymentMeans()) {
                        expectDuePayable = expectDuePayable || paymentMeans.getCode() != null;
                    }
                }
                if (MonetarySummationValidator.belongsToProfile(clazz, "getDuePayable", validationGroupsList) && expectDuePayable && !MonetarySummationValidator.areEqual(monetarySummation.getDuePayable(), calculatedMonetarySummation.getDuePayable())) {
                    message = this.message(monetarySummation.getDuePayable(), calculatedMonetarySummation.getDuePayable());
                    violations.add(new Violation(invoice, message, "monetarySummation.duePayable.error", "trade.settlement.monetarySummation.duePayable", monetarySummation.getDuePayable() != null ? monetarySummation.getDuePayable().getValue() : null));
                }
                if (MonetarySummationValidator.belongsToProfile(clazz, "getLineTotal", validationGroupsList) && !MonetarySummationValidator.areEqual(monetarySummation.getLineTotal(), calculatedMonetarySummation.getLineTotal())) {
                    message = this.message(monetarySummation.getLineTotal(), calculatedMonetarySummation.getLineTotal());
                    violations.add(new Violation(invoice, message, "monetarySummation.lineTotal.error", "trade.settlement.monetarySummation.lineTotal", monetarySummation.getLineTotal() != null ? monetarySummation.getLineTotal().getValue() : null));
                }
                if (MonetarySummationValidator.belongsToProfile(clazz, "getTaxTotal", validationGroupsList) && !MonetarySummationValidator.areEqual(monetarySummation.getTaxTotal(), calculatedMonetarySummation.getTaxTotal())) {
                    message = this.message(monetarySummation.getTaxTotal(), calculatedMonetarySummation.getTaxTotal());
                    violations.add(new Violation(invoice, message, "monetarySummation.taxTotal.error", "trade.settlement.monetarySummation.taxTotal", monetarySummation.getTaxTotal() != null ? monetarySummation.getTaxTotal().getValue() : null));
                }
                if (MonetarySummationValidator.belongsToProfile(clazz, "getTotalPrepaid", validationGroupsList) && !MonetarySummationValidator.areEqual(monetarySummation.getTotalPrepaid(), calculatedMonetarySummation.getTotalPrepaid())) {
                    message = this.message(monetarySummation.getTotalPrepaid(), calculatedMonetarySummation.getTotalPrepaid());
                    violations.add(new Violation(invoice, message, "monetarySummation.totalPrepaid.error", "trade.settlement.monetarySummation.totalPrepaid", monetarySummation.getTotalPrepaid() != null ? monetarySummation.getTotalPrepaid().getValue() : null));
                }
            }
            log.debug("Validating item's specified monetary summations...");
            if (trade.getItems() != null) {
                for (int i = 0; i < trade.getItems().size(); ++i) {
                    String message;
                    SpecifiedSettlement specifiedSettlement;
                    Item item = trade.getItems().get(i);
                    if (item.getSettlement() == null || (specifiedSettlement = item.getSettlement()).getMonetarySummation() == null) continue;
                    SpecifiedMonetarySummation monetarySummation = specifiedSettlement.getMonetarySummation();
                    SpecifiedMonetarySummation calculatedMonetarySummation = AmountCalculator.calculateSpecifiedMonetarySummation(item);
                    if (MonetarySummationValidator.belongsToProfile(SpecifiedMonetarySummation.class, "getLineTotal", validationGroupsList) && !MonetarySummationValidator.areEqual(monetarySummation.getLineTotal(), calculatedMonetarySummation.getLineTotal())) {
                        message = this.message(monetarySummation.getLineTotal(), calculatedMonetarySummation.getLineTotal());
                        violations.add(new Violation(invoice, message, "item.monetarySummation.lineTotal.error", "trade.items[" + i + "].settlement.monetarySummation.lineTotal", monetarySummation.getLineTotal() != null ? monetarySummation.getLineTotal().getValue() : null));
                    }
                    if (!MonetarySummationValidator.belongsToProfile(SpecifiedMonetarySummation.class, "getTotalAllowanceCharge", validationGroupsList) || (!MonetarySummationValidator.grossPriceIncludesCharges(item) || monetarySummation.getTotalAllowanceCharge() != null) && MonetarySummationValidator.areEqual(monetarySummation.getTotalAllowanceCharge(), calculatedMonetarySummation.getTotalAllowanceCharge())) continue;
                    message = this.message(monetarySummation.getTotalAllowanceCharge(), calculatedMonetarySummation.getTotalAllowanceCharge());
                    violations.add(new Violation(invoice, message, "item.monetarySummation.totalAllowanceCharge.error", "trade.items[" + i + "].settlement.monetarySummation.totalAllowanceCharge", monetarySummation.getTotalAllowanceCharge() != null ? monetarySummation.getTotalAllowanceCharge().getValue() : null));
                }
            }
        }
        return violations;
    }

    private static boolean grossPriceIncludesCharges(Item item) {
        GrossPrice grossPrice;
        boolean result = false;
        if (item != null && item.getAgreement() != null && item.getAgreement().getGrossPrice() != null && (grossPrice = item.getAgreement().getGrossPrice()).getAllowanceCharges() != null) {
            return !grossPrice.getAllowanceCharges().isEmpty();
        }
        return result;
    }

    private static boolean isEqualZero(Amount amount) {
        if (amount == null || amount.getValue() == null) {
            return false;
        }
        return BigDecimal.ZERO.setScale(2, RoundingMode.HALF_UP).equals(amount.getValue().setScale(2, RoundingMode.HALF_UP));
    }

    private String message(Amount current, Amount expected) {
        Object currentValue = current != null ? current.getValue() : "null";
        Object expectedValue = expected != null ? expected.getValue() : "null";
        return this.messageInterpolator.interpolate("{io.konik.validation.amount.calculation.error}", (MessageInterpolator.Context)new Violation.Context(currentValue, expectedValue));
    }

    private static boolean areEqual(Amount first, Amount second) {
        if (first == null && second == null) {
            return true;
        }
        if (MonetarySummationValidator.zeroEqualsNull(first, second) || MonetarySummationValidator.zeroEqualsNull(second, first)) {
            return true;
        }
        if (first == null || second == null) {
            return false;
        }
        if (first.getCurrency() != null && second.getCurrency() != null && !first.getCurrency().getCurrency().equals(second.getCurrency().getCurrency())) {
            return false;
        }
        if (first.getValue() != null && second.getValue() != null) {
            return first.getValue().setScale(2, RoundingMode.HALF_UP).equals(second.getValue().setScale(2, RoundingMode.HALF_UP));
        }
        return false;
    }

    private static boolean zeroEqualsNull(Amount first, Amount second) {
        return first == null && second != null && second.getValue() != null && second.getValue().setScale(2, RoundingMode.HALF_UP).equals(BigDecimal.ZERO.setScale(2, RoundingMode.HALF_UP));
    }

    private static class Violation
    implements ConstraintViolation<Invoice> {
        private final Invoice invoice;
        private final String message;
        private final String messageTemplate;
        private final String propertyPath;
        private final Object invalidValue;

        public Violation(Invoice invoice, String message, String messageTemplate, String propertyPath, Object invalidValue) {
            this.invoice = invoice;
            this.message = message;
            this.messageTemplate = messageTemplate;
            this.propertyPath = propertyPath;
            this.invalidValue = invalidValue;
        }

        public String getMessage() {
            return this.message;
        }

        public String getMessageTemplate() {
            return this.messageTemplate;
        }

        public Invoice getRootBean() {
            return this.invoice;
        }

        public Class<Invoice> getRootBeanClass() {
            return Invoice.class;
        }

        public Object getLeafBean() {
            return null;
        }

        public Object[] getExecutableParameters() {
            return new Object[0];
        }

        public Object getExecutableReturnValue() {
            return null;
        }

        public Path getPropertyPath() {
            return PathImpl.createPathFromString((String)this.propertyPath);
        }

        public Object getInvalidValue() {
            return this.invalidValue;
        }

        public ConstraintDescriptor<?> getConstraintDescriptor() {
            return null;
        }

        public <U> U unwrap(Class<U> type) {
            return null;
        }

        static class Context
        implements MessageInterpolator.Context {
            private final Object currentValue;
            private final Object expectedValue;

            public Context(Object currentValue, Object expectedValue) {
                this.currentValue = currentValue;
                this.expectedValue = expectedValue;
            }

            public ConstraintDescriptor<?> getConstraintDescriptor() {
                return new ConstraintDescriptor<Annotation>(){

                    public Annotation getAnnotation() {
                        return null;
                    }

                    public String getMessageTemplate() {
                        return "{io.konik.validation.amount.calculation.error}";
                    }

                    public Set<Class<?>> getGroups() {
                        return null;
                    }

                    public Set<Class<? extends Payload>> getPayload() {
                        return null;
                    }

                    public ConstraintTarget getValidationAppliesTo() {
                        return null;
                    }

                    public List<Class<? extends ConstraintValidator<Annotation, ?>>> getConstraintValidatorClasses() {
                        return new LinkedList();
                    }

                    public Map<String, Object> getAttributes() {
                        HashMap<String, Object> map = new HashMap<String, Object>();
                        map.put("currentValue", Context.this.currentValue);
                        map.put("expectedValue", Context.this.expectedValue);
                        return map;
                    }

                    public Set<ConstraintDescriptor<?>> getComposingConstraints() {
                        return new HashSet();
                    }

                    public boolean isReportAsSingleViolation() {
                        return false;
                    }
                };
            }

            public Object getValidatedValue() {
                return this.currentValue;
            }

            public <T> T unwrap(Class<T> type) {
                return null;
            }
        }
    }
}

