/*
 * Decompiled with CFR 0.152.
 */
package io.konik.zugferd.entity;

import io.konik.jaxb.adapter.ParameterProfileAdapter;
import io.konik.validator.annotation.Basic;
import io.konik.validator.annotation.Extended;
import io.konik.zugferd.entity.Parameter;
import io.konik.zugferd.profile.ConformanceLevel;
import io.konik.zugferd.profile.Profile;
import io.konik.zugferd.unqualified.Indicator;
import java.io.Serializable;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;

@XmlType(name="ExchangedDocumentContextType", propOrder={"test", "businessProcess", "guideline"})
public class Context
implements Serializable {
    @XmlElement(name="TestIndicator")
    private Indicator test;
    @XmlElement(name="BusinessProcessSpecifiedDocumentContextParameter")
    private Parameter businessProcess;
    @XmlElement(name="GuidelineSpecifiedDocumentContextParameter", required=true)
    @XmlJavaTypeAdapter(value=ParameterProfileAdapter.class)
    private Profile guideline;

    public Context() {
    }

    public Context(ConformanceLevel conformanceLevel) {
        this.guideline = new Profile(conformanceLevel);
    }

    @Basic
    public boolean isTest() {
        if (this.test == null) {
            return false;
        }
        return this.test.getIndicator();
    }

    public Context setTest() {
        this.test = Indicator.trueIndicator();
        return this;
    }

    public Context setNotTest() {
        this.test = Indicator.falseIndicator();
        return this;
    }

    @Extended
    public String getBusinessProcess() {
        return this.businessProcess == null ? null : this.businessProcess.getId();
    }

    public Context setBusinessProcess(String businessProcess) {
        this.businessProcess = new Parameter(businessProcess);
        return this;
    }

    @Basic
    @NotNull
    @Valid
    public Profile getGuideline() {
        return this.guideline;
    }

    public Context setGuideline(Profile guideline) {
        this.guideline = guideline;
        return this;
    }
}

