/*
 * Decompiled with CFR 0.152.
 */
package io.konik.zugferd.entity;

import com.neovisionaries.i18n.LanguageCode;
import io.konik.jaxb.adapter.PeriodCompleteToDateTimeAdapter;
import io.konik.validator.annotation.Basic;
import io.konik.validator.annotation.Extended;
import io.konik.validator.annotation.NotBlank;
import io.konik.zugferd.entity.Note;
import io.konik.zugferd.unece.codes.DocumentCode;
import io.konik.zugferd.unqualified.Indicator;
import io.konik.zugferd.unqualified.ZfDate;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.CollapsedStringAdapter;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="HeaderExchangedDocument", propOrder={"invoiceNumber", "name", "code", "issued", "copy", "languages", "notes", "contractualDueDate"})
public class Header
implements Serializable {
    @XmlElement(name="ID")
    @XmlJavaTypeAdapter(value=CollapsedStringAdapter.class)
    private String invoiceNumber;
    @XmlElement(name="Name")
    private String name;
    @XmlElement(name="TypeCode")
    private DocumentCode code;
    @XmlElement(name="IssueDateTime")
    private ZfDate issued;
    @XmlElement(name="CopyIndicator")
    private Indicator copy;
    @XmlElement(name="LanguageID")
    private List<LanguageCode> languages;
    @XmlElement(name="IncludedNote")
    private List<Note> notes;
    @XmlElement(name="EffectiveSpecifiedPeriod")
    @XmlJavaTypeAdapter(value=PeriodCompleteToDateTimeAdapter.class)
    private ZfDate contractualDueDate;

    @Basic
    @NotBlank
    public String getInvoiceNumber() {
        return this.invoiceNumber;
    }

    public Header setInvoiceNumber(String invoiceNumber) {
        this.invoiceNumber = invoiceNumber;
        return this;
    }

    @Basic
    @NotBlank
    public String getName() {
        return this.name;
    }

    public Header setName(String name) {
        this.name = name;
        return this;
    }

    @Basic
    @NotNull
    public DocumentCode getCode() {
        return this.code;
    }

    public Header setCode(DocumentCode code) {
        this.code = code;
        return this;
    }

    @Basic
    @Valid
    @NotNull
    public ZfDate getIssued() {
        return this.issued;
    }

    public Header setIssued(ZfDate issued) {
        this.issued = issued;
        return this;
    }

    @Extended
    public boolean isCopy() {
        return this.copy == null ? false : this.copy.getIndicator();
    }

    public void setCopy(boolean copy) {
        this.copy = new Indicator(copy);
    }

    @Extended
    public List<LanguageCode> getLanguages() {
        if (this.languages == null) {
            this.languages = new ArrayList<LanguageCode>();
        }
        return this.languages;
    }

    public void addLanguage(LanguageCode language) {
        this.getLanguages().add(language);
    }

    @Basic
    @Valid
    public List<Note> getNotes() {
        if (this.notes == null) {
            this.notes = new ArrayList<Note>();
        }
        return this.notes;
    }

    public Header addNote(Note ... additionalNote) {
        Collections.addAll(this.getNotes(), additionalNote);
        return this;
    }

    @Extended
    public ZfDate getContractualDueDate() {
        return this.contractualDueDate;
    }

    public Header setContractualDueDate(ZfDate contractualDueDate) {
        this.contractualDueDate = contractualDueDate;
        return this;
    }
}

