/*
 * Decompiled with CFR 0.152.
 */
package io.konik.zugferd.entity;

import io.konik.validator.annotation.Basic;
import io.konik.validator.annotation.Comfort;
import io.konik.validator.annotation.Extended;
import io.konik.validator.annotation.NotEmpty;
import io.konik.validator.annotation.NullableNotBlank;
import io.konik.zugferd.entity.Header;
import io.konik.zugferd.entity.PositionDocument;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.CollapsedStringAdapter;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;

@XmlType(name="NoteType", propOrder={"contentCode", "contents", "subjectCode"})
public class Note
implements Serializable {
    @XmlElement(name="ContentCode")
    @XmlJavaTypeAdapter(value=CollapsedStringAdapter.class)
    private String contentCode;
    @XmlElement(name="Content")
    private List<String> contents;
    @XmlElement(name="SubjectCode")
    @XmlJavaTypeAdapter(value=CollapsedStringAdapter.class)
    private String subjectCode;

    public Note() {
    }

    public Note(String content) {
        this.addContent(content);
    }

    public Note(String content, String subjectCode) {
        this.addContent(content);
        this.subjectCode = subjectCode;
    }

    @Extended
    @NullableNotBlank
    public String getContentCode() {
        return this.contentCode;
    }

    public Note setContentCode(String contentCode) {
        this.contentCode = contentCode;
        return this;
    }

    @Basic(ifParent={Header.class})
    @Comfort(ifParent={PositionDocument.class})
    @NotEmpty
    public List<String> getContents() {
        if (this.contents == null) {
            this.contents = new ArrayList<String>();
        }
        return this.contents;
    }

    public Note addContent(String content) {
        this.getContents().add(content);
        return this;
    }

    @Comfort(ifParent={Header.class})
    @Extended(ifParent={PositionDocument.class})
    @NullableNotBlank
    public String getSubjectCode() {
        return this.subjectCode;
    }

    public Note setSubjectCode(String subjectCode) {
        this.subjectCode = subjectCode;
        return this;
    }
}

