/*
 * Decompiled with CFR 0.152.
 */
package io.konik.zugferd.entity;

import io.konik.validator.annotation.Comfort;
import io.konik.validator.annotation.Extended;
import io.konik.validator.annotation.NotEmpty;
import io.konik.zugferd.entity.PaymentDiscountTerms;
import io.konik.zugferd.entity.PaymentPenaltyTerms;
import io.konik.zugferd.unqualified.Amount;
import io.konik.zugferd.unqualified.ZfDate;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.validation.Valid;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;

@XmlType(name="TradePaymentTermsType", propOrder={"descriptions", "due", "partialPayments", "penalty", "discount"})
public class PaymentTerm
implements Serializable {
    @XmlElement(name="Description")
    protected List<String> descriptions;
    @XmlElement(name="DueDateDateTime")
    private ZfDate due;
    @XmlElement(name="PartialPaymentAmount")
    private List<Amount> partialPayments;
    @XmlElement(name="ApplicableTradePaymentPenaltyTerms")
    private PaymentPenaltyTerms penalty;
    @XmlElement(name="ApplicableTradePaymentDiscountTerms")
    private PaymentDiscountTerms discount;

    @Comfort
    @NotEmpty
    public List<String> getDescriptions() {
        if (this.descriptions == null) {
            this.descriptions = new ArrayList<String>();
        }
        return this.descriptions;
    }

    public PaymentTerm addDescription(String description) {
        this.getDescriptions().add(description);
        return this;
    }

    @Comfort
    public ZfDate getDue() {
        return this.due;
    }

    public PaymentTerm setDue(ZfDate due) {
        this.due = due;
        return this;
    }

    @Extended
    @Valid
    public List<Amount> getPartialPayments() {
        if (this.partialPayments == null) {
            this.partialPayments = new ArrayList<Amount>();
        }
        return this.partialPayments;
    }

    public PaymentTerm addPartialPayments(Amount partialPayment) {
        this.getPartialPayments().add(partialPayment);
        return this;
    }

    public PaymentPenaltyTerms getPenalty() {
        return this.penalty;
    }

    public PaymentTerm setPenalty(PaymentPenaltyTerms penalty) {
        this.penalty = penalty;
        return this;
    }

    public PaymentDiscountTerms getDiscount() {
        return this.discount;
    }

    public PaymentTerm setDiscount(PaymentDiscountTerms discount) {
        this.discount = discount;
        return this;
    }
}

