/*
 * Decompiled with CFR 0.152.
 */
package io.konik.zugferd.entity;

import com.neovisionaries.i18n.CountryCode;
import io.konik.jaxb.adapter.CountryAdapter;
import io.konik.validator.annotation.Basic;
import io.konik.validator.annotation.Comfort;
import io.konik.validator.annotation.Extended;
import io.konik.validator.annotation.NotBlank;
import io.konik.zugferd.entity.ProductCharacteristic;
import io.konik.zugferd.entity.ProductClassification;
import io.konik.zugferd.entity.ReferencedProduct;
import io.konik.zugferd.unqualified.ID;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.validation.Valid;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.CollapsedStringAdapter;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;

@XmlType(name="TradeProductType", propOrder={"globalId", "sellerAssignedId", "buyerAssignedId", "name", "description", "characteristics", "classifications", "origins", "containedProducts"})
public class Product
implements Serializable {
    @XmlElement(name="GlobalID")
    private ID globalId;
    @XmlElement(name="SellerAssignedID")
    @XmlJavaTypeAdapter(value=CollapsedStringAdapter.class)
    private String sellerAssignedId;
    @XmlElement(name="BuyerAssignedID")
    @XmlJavaTypeAdapter(value=CollapsedStringAdapter.class)
    private String buyerAssignedId;
    @XmlElement(name="Name")
    private String name;
    @XmlElement(name="Description")
    private String description;
    @Valid
    @XmlElement(name="ApplicableProductCharacteristic")
    private List<ProductCharacteristic> characteristics;
    @XmlElement(name="DesignatedProductClassification")
    @Valid
    private List<ProductClassification> classifications;
    @Valid
    @XmlElement(name="OriginTradeCountry")
    @XmlJavaTypeAdapter(value=CountryAdapter.class)
    private List<CountryCode> origins;
    @XmlElement(name="IncludedReferencedProduct")
    @Valid
    private List<ReferencedProduct> containedProducts;

    @Comfort
    @Valid
    public ID getGlobalId() {
        return this.globalId;
    }

    public Product setGlobalId(ID productGlobalId) {
        this.globalId = productGlobalId;
        return this;
    }

    @Comfort
    public String getSellerAssignedId() {
        return this.sellerAssignedId;
    }

    public Product setSellerAssignedId(String sellerAssignedId) {
        this.sellerAssignedId = sellerAssignedId;
        return this;
    }

    @Comfort
    public String getBuyerAssignedId() {
        return this.buyerAssignedId;
    }

    public Product setBuyerAssignedId(String buyerAssignedId) {
        this.buyerAssignedId = buyerAssignedId;
        return this;
    }

    @Basic
    @NotBlank
    public String getName() {
        return this.name;
    }

    public Product setName(String name) {
        this.name = name;
        return this;
    }

    @Comfort
    public String getDescription() {
        return this.description;
    }

    public Product setDescription(String description) {
        this.description = description;
        return this;
    }

    @Extended
    @Valid
    public List<ProductCharacteristic> getCharacteristics() {
        if (this.characteristics == null) {
            this.characteristics = new ArrayList<ProductCharacteristic>();
        }
        return this.characteristics;
    }

    public Product addCharacteristic(ProductCharacteristic characteristic) {
        this.getCharacteristics().add(characteristic);
        return this;
    }

    @Extended
    @Valid
    public List<ProductClassification> getClassifications() {
        if (this.classifications == null) {
            this.classifications = new ArrayList<ProductClassification>();
        }
        return this.classifications;
    }

    public Product addClassification(ProductClassification classification) {
        this.getClassifications().add(classification);
        return this;
    }

    @Extended
    public List<CountryCode> getOrigins() {
        if (this.origins == null) {
            this.origins = new ArrayList<CountryCode>();
        }
        return this.origins;
    }

    public Product addOrigins(CountryCode originCountry) {
        this.getOrigins().add(originCountry);
        return this;
    }

    @Extended
    @Valid
    public List<ReferencedProduct> getContainedProducts() {
        if (this.containedProducts == null) {
            this.containedProducts = new ArrayList<ReferencedProduct>();
        }
        return this.containedProducts;
    }

    public Product addContainedProducts(ReferencedProduct containedProduct) {
        this.getContainedProducts().add(containedProduct);
        return this;
    }
}

