/*
 * Decompiled with CFR 0.152.
 */
package io.konik.zugferd.entity;

import io.konik.jaxb.adapter.IssueDateTimeAdapter;
import io.konik.validator.annotation.Comfort;
import io.konik.validator.annotation.NotBlank;
import java.io.Serializable;
import java.util.Date;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.CollapsedStringAdapter;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;

@XmlType(name="ReferencedDocumentType", propOrder={"issued", "linePos", "typeCode", "id", "referenceType"})
public class ReferencedDocument
implements Serializable {
    @XmlElement(name="IssueDateTime")
    @XmlJavaTypeAdapter(value=IssueDateTimeAdapter.class)
    private Date issued;
    @XmlElement(name="LineID")
    protected String linePos;
    @XmlElement(name="TypeCode")
    @XmlJavaTypeAdapter(value=CollapsedStringAdapter.class)
    protected String typeCode;
    @XmlElement(name="ID")
    @XmlJavaTypeAdapter(value=CollapsedStringAdapter.class)
    private String id;
    @XmlElement(name="ReferenceTypeCode")
    @XmlJavaTypeAdapter(value=CollapsedStringAdapter.class)
    protected String referenceType;

    protected ReferencedDocument() {
    }

    public ReferencedDocument(String identifier) {
        this.id = identifier;
    }

    @Comfort
    public Date getIssued() {
        return this.issued == null ? null : new Date(this.issued.getTime());
    }

    public ReferencedDocument setIssued(Date issued) {
        if (issued != null) {
            this.issued = new Date(issued.getTime());
        }
        return this;
    }

    public ReferencedDocument setId(String referenceDocumentIdentifier) {
        this.id = referenceDocumentIdentifier;
        return this;
    }

    @Comfort
    @NotBlank(groups={Comfort.class})
    public String getId() {
        return this.id;
    }
}

