/*
 * Decompiled with CFR 0.152.
 */
package io.konik.zugferd.entity;

import io.konik.validator.annotation.Extended;
import io.konik.validator.annotation.NotEmpty;
import io.konik.zugferd.unqualified.ID;
import io.konik.zugferd.unqualified.Quantity;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.validation.Valid;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.CollapsedStringAdapter;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;

@Extended
@XmlType(name="ReferencedProductType", propOrder={"globalIds", "sellerAssignedId", "buyerAssignedId", "names", "descriptions", "units"})
public class ReferencedProduct
implements Serializable {
    @XmlElement(name="GlobalID")
    private List<ID> globalIds;
    @XmlElement(name="SellerAssignedID")
    @XmlJavaTypeAdapter(value=CollapsedStringAdapter.class)
    private String sellerAssignedId;
    @XmlElement(name="BuyerAssignedID")
    @XmlJavaTypeAdapter(value=CollapsedStringAdapter.class)
    private String buyerAssignedId;
    @XmlElement(name="Name")
    private List<String> names;
    @XmlElement(name="Description")
    private List<String> descriptions;
    @XmlElement(name="UnitQuantity")
    private List<Quantity> units;

    @Valid
    public List<ID> getGlobalIds() {
        if (this.globalIds == null) {
            this.globalIds = new ArrayList<ID>();
        }
        return this.globalIds;
    }

    public ReferencedProduct addGlobalIds(ID globarId) {
        this.getGlobalIds().add(globarId);
        return this;
    }

    public String getSellerAssignedId() {
        return this.sellerAssignedId;
    }

    public void setSellerAssignedId(String sellerAsignedId) {
        this.sellerAssignedId = sellerAsignedId;
    }

    public String getBuyerAssignedId() {
        return this.buyerAssignedId;
    }

    public void setBuyerAssignedId(String buyerAssignedId) {
        this.buyerAssignedId = buyerAssignedId;
    }

    @NotEmpty
    public List<String> getNames() {
        if (this.names == null) {
            this.names = new ArrayList<String>();
        }
        return this.names;
    }

    public ReferencedProduct addNames(String name) {
        this.getNames().add(name);
        return this;
    }

    public List<String> getDescriptions() {
        if (this.descriptions == null) {
            this.descriptions = new ArrayList<String>();
        }
        return this.descriptions;
    }

    public ReferencedProduct addDescription(String description) {
        this.getDescriptions().add(description);
        return this;
    }

    @Valid
    public List<Quantity> getUnits() {
        if (this.units == null) {
            this.units = new ArrayList<Quantity>();
        }
        return this.units;
    }

    public ReferencedProduct addUnits(Quantity unit) {
        this.getUnits().add(unit);
        return this;
    }
}

