/*
 * Decompiled with CFR 0.152.
 */
package io.konik.zugferd.entity;

import io.konik.jaxb.adapter.TwoDigitRoundingAdapter;
import io.konik.jaxb.bindable.unqualified.PercentRoundingAdapter;
import io.konik.validator.annotation.Comfort;
import io.konik.validator.annotation.Extended;
import io.konik.zugferd.entity.AppliedTax;
import io.konik.zugferd.entity.CommonAllowanceCharge;
import io.konik.zugferd.unqualified.Amount;
import io.konik.zugferd.unqualified.Indicator;
import io.konik.zugferd.unqualified.Quantity;
import java.math.BigDecimal;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.CollapsedStringAdapter;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;

@XmlType(name="", propOrder={"surcharge", "sequence", "calculationPercent", "basis", "basisQuantity", "actual", "reasonCode", "reason", "category"})
public class SpecifiedAllowanceCharge
implements CommonAllowanceCharge {
    @XmlElement(name="ChargeIndicator")
    private Indicator surcharge = Indicator.falseIndicator();
    @XmlElement(name="SequenceNumeric")
    private BigDecimal sequence;
    @XmlElement(name="CalculationPercent")
    @XmlJavaTypeAdapter(value=PercentRoundingAdapter.class)
    private BigDecimal calculationPercent;
    @XmlElement(name="BasisAmount")
    @XmlJavaTypeAdapter(value=TwoDigitRoundingAdapter.class)
    private Amount basis;
    @XmlElement(name="BasisQuantity")
    private Quantity basisQuantity;
    @XmlElement(name="ActualAmount")
    @XmlJavaTypeAdapter(value=TwoDigitRoundingAdapter.class)
    private Amount actual;
    @XmlElement(name="ReasonCode")
    @XmlJavaTypeAdapter(value=CollapsedStringAdapter.class)
    private String reasonCode;
    @XmlElement(name="Reason")
    private String reason;
    @XmlElement(name="CategoryTradeTax")
    private AppliedTax category;

    @Override
    @NotNull(groups={Comfort.class})
    public boolean isSurcharge() {
        return this.surcharge.getIndicator();
    }

    @Override
    @NotNull(groups={Comfort.class})
    public boolean isDiscount() {
        return !this.surcharge.getIndicator();
    }

    @Override
    public SpecifiedAllowanceCharge setSurcharge() {
        this.surcharge = Indicator.trueIndicator();
        return this;
    }

    @Override
    public SpecifiedAllowanceCharge setDiscount() {
        this.surcharge = Indicator.falseIndicator();
        return this;
    }

    @Override
    @Extended
    public BigDecimal getSequence() {
        return this.sequence;
    }

    @Override
    public SpecifiedAllowanceCharge setSequence(BigDecimal sequence) {
        this.sequence = sequence;
        return this;
    }

    @Override
    @Extended
    public BigDecimal getCalculationPercent() {
        return this.calculationPercent;
    }

    @Override
    public SpecifiedAllowanceCharge setCalculationPercent(BigDecimal calculationPercent) {
        this.calculationPercent = calculationPercent;
        return this;
    }

    @Override
    @Valid
    @Extended
    public Amount getBasis() {
        return this.basis;
    }

    @Override
    public SpecifiedAllowanceCharge setBasis(Amount basisAmount) {
        this.basis = basisAmount;
        return this;
    }

    @Override
    @Extended
    @Valid
    public Quantity getBasisQuantity() {
        return this.basisQuantity;
    }

    @Override
    public SpecifiedAllowanceCharge setBasisQuantity(Quantity basisQuantity) {
        this.basisQuantity = basisQuantity;
        return this;
    }

    @Override
    @Valid
    @NotNull(groups={Comfort.class})
    public Amount getActual() {
        return this.actual;
    }

    @Override
    public SpecifiedAllowanceCharge setActual(Amount actualAmount) {
        this.actual = actualAmount;
        return this;
    }

    @Override
    @Extended
    public String getReasonCode() {
        return this.reasonCode;
    }

    @Override
    public SpecifiedAllowanceCharge setReasonCode(String reasonCode) {
        this.reasonCode = reasonCode;
        return this;
    }

    @Override
    @Comfort
    public String getReason() {
        return this.reason;
    }

    @Override
    public SpecifiedAllowanceCharge setReason(String reason) {
        this.reason = reason;
        return this;
    }

    @Comfort
    public AppliedTax getCategory() {
        return this.category;
    }

    public SpecifiedAllowanceCharge setCategory(AppliedTax category) {
        this.category = category;
        return this;
    }
}

