/*
 * Decompiled with CFR 0.152.
 */
package io.konik.zugferd.entity;

import io.konik.util.Strings;
import io.konik.validator.annotation.NotBlank;
import io.konik.zugferd.unece.codes.Reference;
import io.konik.zugferd.unqualified.ID;
import java.io.Serializable;
import javax.validation.constraints.NotNull;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;

@XmlType(name="TaxRegistrationType", propOrder={"id"})
public class TaxRegistration
implements Serializable {
    @XmlElement(name="ID")
    private ID id;

    public TaxRegistration() {
        this.id = new ID();
    }

    public TaxRegistration(String taxNumber) {
        this.id = new ID(taxNumber);
    }

    public TaxRegistration(String taxNumber, Reference typeOfTax) {
        this.id = new ID(taxNumber, typeOfTax.getCode());
    }

    @NotBlank
    public String getTaxNumber() {
        return this.id.getValue();
    }

    public TaxRegistration setTaxNumber(String taxNumber) {
        if (Strings.isNotEmpty(taxNumber)) {
            this.id.setValue(taxNumber);
        }
        return this;
    }

    @NotNull
    public Reference getType() {
        return Reference.getByCode(this.id.getSchemeId());
    }

    public TaxRegistration setType(Reference taxType) {
        if (taxType != null) {
            this.id.setSchemeId(taxType.getCode());
        }
        return this;
    }
}

